package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteEventStreaming invokes the eventbridge.DeleteEventStreaming API synchronously
func (client *Client) DeleteEventStreaming(request *DeleteEventStreamingRequest) (response *DeleteEventStreamingResponse, err error) {
	response = CreateDeleteEventStreamingResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteEventStreamingWithChan invokes the eventbridge.DeleteEventStreaming API asynchronously
func (client *Client) DeleteEventStreamingWithChan(request *DeleteEventStreamingRequest) (<-chan *DeleteEventStreamingResponse, <-chan error) {
	responseChan := make(chan *DeleteEventStreamingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteEventStreaming(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteEventStreamingWithCallback invokes the eventbridge.DeleteEventStreaming API asynchronously
func (client *Client) DeleteEventStreamingWithCallback(request *DeleteEventStreamingRequest, callback func(response *DeleteEventStreamingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteEventStreamingResponse
		var err error
		defer close(result)
		response, err = client.DeleteEventStreaming(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteEventStreamingRequest is the request struct for api DeleteEventStreaming
type DeleteEventStreamingRequest struct {
	*requests.RpcRequest
	EventStreamingName string `position:"Body" name:"EventStreamingName"`
}

// DeleteEventStreamingResponse is the response struct for api DeleteEventStreaming
type DeleteEventStreamingResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      bool   `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDeleteEventStreamingRequest creates a request to invoke DeleteEventStreaming API
func CreateDeleteEventStreamingRequest() (request *DeleteEventStreamingRequest) {
	request = &DeleteEventStreamingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "DeleteEventStreaming", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteEventStreamingResponse creates a response to parse from DeleteEventStreaming response
func CreateDeleteEventStreamingResponse() (response *DeleteEventStreamingResponse) {
	response = &DeleteEventStreamingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
