package eventbridge

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateEventBus invokes the eventbridge.CreateEventBus API synchronously
func (client *Client) CreateEventBus(request *CreateEventBusRequest) (response *CreateEventBusResponse, err error) {
	response = CreateCreateEventBusResponse()
	err = client.DoAction(request, response)
	return
}

// CreateEventBusWithChan invokes the eventbridge.CreateEventBus API asynchronously
func (client *Client) CreateEventBusWithChan(request *CreateEventBusRequest) (<-chan *CreateEventBusResponse, <-chan error) {
	responseChan := make(chan *CreateEventBusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateEventBus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateEventBusWithCallback invokes the eventbridge.CreateEventBus API asynchronously
func (client *Client) CreateEventBusWithCallback(request *CreateEventBusRequest, callback func(response *CreateEventBusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateEventBusResponse
		var err error
		defer close(result)
		response, err = client.CreateEventBus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateEventBusRequest is the request struct for api CreateEventBus
type CreateEventBusRequest struct {
	*requests.RpcRequest
	ClientToken  string `position:"Query" name:"ClientToken"`
	Description  string `position:"Query" name:"Description"`
	EventBusName string `position:"Query" name:"EventBusName"`
}

// CreateEventBusResponse is the response struct for api CreateEventBus
type CreateEventBusResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateEventBusRequest creates a request to invoke CreateEventBus API
func CreateCreateEventBusRequest() (request *CreateEventBusRequest) {
	request = &CreateEventBusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eventbridge", "2020-04-01", "CreateEventBus", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateEventBusResponse creates a response to parse from CreateEventBus response
func CreateCreateEventBusResponse() (response *CreateEventBusResponse) {
	response = &CreateEventBusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
