package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// StopSnatIpForSnatEntry invokes the ens.StopSnatIpForSnatEntry API synchronously
func (client *Client) StopSnatIpForSnatEntry(request *StopSnatIpForSnatEntryRequest) (response *StopSnatIpForSnatEntryResponse, err error) {
	response = CreateStopSnatIpForSnatEntryResponse()
	err = client.DoAction(request, response)
	return
}

// StopSnatIpForSnatEntryWithChan invokes the ens.StopSnatIpForSnatEntry API asynchronously
func (client *Client) StopSnatIpForSnatEntryWithChan(request *StopSnatIpForSnatEntryRequest) (<-chan *StopSnatIpForSnatEntryResponse, <-chan error) {
	responseChan := make(chan *StopSnatIpForSnatEntryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.StopSnatIpForSnatEntry(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// StopSnatIpForSnatEntryWithCallback invokes the ens.StopSnatIpForSnatEntry API asynchronously
func (client *Client) StopSnatIpForSnatEntryWithCallback(request *StopSnatIpForSnatEntryRequest, callback func(response *StopSnatIpForSnatEntryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *StopSnatIpForSnatEntryResponse
		var err error
		defer close(result)
		response, err = client.StopSnatIpForSnatEntry(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// StopSnatIpForSnatEntryRequest is the request struct for api StopSnatIpForSnatEntry
type StopSnatIpForSnatEntryRequest struct {
	*requests.RpcRequest
	SnatIp      string `position:"Query" name:"SnatIp"`
	SnatEntryId string `position:"Query" name:"SnatEntryId"`
}

// StopSnatIpForSnatEntryResponse is the response struct for api StopSnatIpForSnatEntry
type StopSnatIpForSnatEntryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateStopSnatIpForSnatEntryRequest creates a request to invoke StopSnatIpForSnatEntry API
func CreateStopSnatIpForSnatEntryRequest() (request *StopSnatIpForSnatEntryRequest) {
	request = &StopSnatIpForSnatEntryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "StopSnatIpForSnatEntry", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateStopSnatIpForSnatEntryResponse creates a response to parse from StopSnatIpForSnatEntry response
func CreateStopSnatIpForSnatEntryResponse() (response *StopSnatIpForSnatEntryResponse) {
	response = &StopSnatIpForSnatEntryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
