package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSDGs invokes the ens.DescribeSDGs API synchronously
func (client *Client) DescribeSDGs(request *DescribeSDGsRequest) (response *DescribeSDGsResponse, err error) {
	response = CreateDescribeSDGsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSDGsWithChan invokes the ens.DescribeSDGs API asynchronously
func (client *Client) DescribeSDGsWithChan(request *DescribeSDGsRequest) (<-chan *DescribeSDGsResponse, <-chan error) {
	responseChan := make(chan *DescribeSDGsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSDGs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSDGsWithCallback invokes the ens.DescribeSDGs API asynchronously
func (client *Client) DescribeSDGsWithCallback(request *DescribeSDGsRequest, callback func(response *DescribeSDGsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSDGsResponse
		var err error
		defer close(result)
		response, err = client.DescribeSDGs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSDGsRequest is the request struct for api DescribeSDGs
type DescribeSDGsRequest struct {
	*requests.RpcRequest
	SDGIds      *[]string `position:"Query" name:"SDGIds"  type:"Json"`
	InstanceIds *[]string `position:"Query" name:"InstanceIds"  type:"Json"`
}

// DescribeSDGsResponse is the response struct for api DescribeSDGs
type DescribeSDGsResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	SDGs      []SDGsItem `json:"SDGs" xml:"SDGs"`
}

// CreateDescribeSDGsRequest creates a request to invoke DescribeSDGs API
func CreateDescribeSDGsRequest() (request *DescribeSDGsRequest) {
	request = &DescribeSDGsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "DescribeSDGs", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSDGsResponse creates a response to parse from DescribeSDGs response
func CreateDescribeSDGsResponse() (response *DescribeSDGsResponse) {
	response = &DescribeSDGsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
