package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateStorageVolume invokes the ens.CreateStorageVolume API synchronously
func (client *Client) CreateStorageVolume(request *CreateStorageVolumeRequest) (response *CreateStorageVolumeResponse, err error) {
	response = CreateCreateStorageVolumeResponse()
	err = client.DoAction(request, response)
	return
}

// CreateStorageVolumeWithChan invokes the ens.CreateStorageVolume API asynchronously
func (client *Client) CreateStorageVolumeWithChan(request *CreateStorageVolumeRequest) (<-chan *CreateStorageVolumeResponse, <-chan error) {
	responseChan := make(chan *CreateStorageVolumeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateStorageVolume(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateStorageVolumeWithCallback invokes the ens.CreateStorageVolume API asynchronously
func (client *Client) CreateStorageVolumeWithCallback(request *CreateStorageVolumeRequest, callback func(response *CreateStorageVolumeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateStorageVolumeResponse
		var err error
		defer close(result)
		response, err = client.CreateStorageVolume(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateStorageVolumeRequest is the request struct for api CreateStorageVolume
type CreateStorageVolumeRequest struct {
	*requests.RpcRequest
	EnsRegionId  string `position:"Query" name:"EnsRegionId"`
	GatewayId    string `position:"Query" name:"GatewayId"`
	AuthUser     string `position:"Query" name:"AuthUser"`
	VolumeName   string `position:"Query" name:"VolumeName"`
	AuthPassword string `position:"Query" name:"AuthPassword"`
	AuthProtocol string `position:"Query" name:"AuthProtocol"`
	Description  string `position:"Query" name:"Description"`
	IsEnable     string `position:"Query" name:"IsEnable"`
	IsAuth       string `position:"Query" name:"IsAuth"`
	StorageId    string `position:"Query" name:"StorageId"`
}

// CreateStorageVolumeResponse is the response struct for api CreateStorageVolume
type CreateStorageVolumeResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	VolumeId  []string `json:"VolumeId" xml:"VolumeId"`
}

// CreateCreateStorageVolumeRequest creates a request to invoke CreateStorageVolume API
func CreateCreateStorageVolumeRequest() (request *CreateStorageVolumeRequest) {
	request = &CreateStorageVolumeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "CreateStorageVolume", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateStorageVolumeResponse creates a response to parse from CreateStorageVolume response
func CreateCreateStorageVolumeResponse() (response *CreateStorageVolumeResponse) {
	response = &CreateStorageVolumeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
