package ens

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachInstanceSDG invokes the ens.AttachInstanceSDG API synchronously
func (client *Client) AttachInstanceSDG(request *AttachInstanceSDGRequest) (response *AttachInstanceSDGResponse, err error) {
	response = CreateAttachInstanceSDGResponse()
	err = client.DoAction(request, response)
	return
}

// AttachInstanceSDGWithChan invokes the ens.AttachInstanceSDG API asynchronously
func (client *Client) AttachInstanceSDGWithChan(request *AttachInstanceSDGRequest) (<-chan *AttachInstanceSDGResponse, <-chan error) {
	responseChan := make(chan *AttachInstanceSDGResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachInstanceSDG(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachInstanceSDGWithCallback invokes the ens.AttachInstanceSDG API asynchronously
func (client *Client) AttachInstanceSDGWithCallback(request *AttachInstanceSDGRequest, callback func(response *AttachInstanceSDGResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachInstanceSDGResponse
		var err error
		defer close(result)
		response, err = client.AttachInstanceSDG(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachInstanceSDGRequest is the request struct for api AttachInstanceSDG
type AttachInstanceSDGRequest struct {
	*requests.RpcRequest
	SDGId       string    `position:"Query" name:"SDGId"`
	InstanceIds *[]string `position:"Query" name:"InstanceIds"  type:"Json"`
}

// AttachInstanceSDGResponse is the response struct for api AttachInstanceSDG
type AttachInstanceSDGResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateAttachInstanceSDGRequest creates a request to invoke AttachInstanceSDG API
func CreateAttachInstanceSDGRequest() (request *AttachInstanceSDGRequest) {
	request = &AttachInstanceSDGRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ens", "2017-11-10", "AttachInstanceSDG", "ens", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAttachInstanceSDGResponse creates a response to parse from AttachInstanceSDG response
func CreateAttachInstanceSDGResponse() (response *AttachInstanceSDGResponse) {
	response = &AttachInstanceSDGResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
