package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFlowNodeSqlResult invokes the emr.ListFlowNodeSqlResult API synchronously
func (client *Client) ListFlowNodeSqlResult(request *ListFlowNodeSqlResultRequest) (response *ListFlowNodeSqlResultResponse, err error) {
	response = CreateListFlowNodeSqlResultResponse()
	err = client.DoAction(request, response)
	return
}

// ListFlowNodeSqlResultWithChan invokes the emr.ListFlowNodeSqlResult API asynchronously
func (client *Client) ListFlowNodeSqlResultWithChan(request *ListFlowNodeSqlResultRequest) (<-chan *ListFlowNodeSqlResultResponse, <-chan error) {
	responseChan := make(chan *ListFlowNodeSqlResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFlowNodeSqlResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFlowNodeSqlResultWithCallback invokes the emr.ListFlowNodeSqlResult API asynchronously
func (client *Client) ListFlowNodeSqlResultWithCallback(request *ListFlowNodeSqlResultRequest, callback func(response *ListFlowNodeSqlResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFlowNodeSqlResultResponse
		var err error
		defer close(result)
		response, err = client.ListFlowNodeSqlResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFlowNodeSqlResultRequest is the request struct for api ListFlowNodeSqlResult
type ListFlowNodeSqlResultRequest struct {
	*requests.RpcRequest
	Offset         requests.Integer `position:"Query" name:"Offset"`
	Length         requests.Integer `position:"Query" name:"Length"`
	SqlIndex       requests.Integer `position:"Query" name:"SqlIndex"`
	NodeInstanceId string           `position:"Query" name:"NodeInstanceId"`
	ProjectId      string           `position:"Query" name:"ProjectId"`
}

// ListFlowNodeSqlResultResponse is the response struct for api ListFlowNodeSqlResult
type ListFlowNodeSqlResultResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	End        bool       `json:"End" xml:"End"`
	HeaderList HeaderList `json:"HeaderList" xml:"HeaderList"`
	RowList    RowList    `json:"RowList" xml:"RowList"`
}

// CreateListFlowNodeSqlResultRequest creates a request to invoke ListFlowNodeSqlResult API
func CreateListFlowNodeSqlResultRequest() (request *ListFlowNodeSqlResultRequest) {
	request = &ListFlowNodeSqlResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListFlowNodeSqlResult", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListFlowNodeSqlResultResponse creates a response to parse from ListFlowNodeSqlResult response
func CreateListFlowNodeSqlResultResponse() (response *ListFlowNodeSqlResultResponse) {
	response = &ListFlowNodeSqlResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
