package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDicts invokes the elasticsearch.ListDicts API synchronously
func (client *Client) ListDicts(request *ListDictsRequest) (response *ListDictsResponse, err error) {
	response = CreateListDictsResponse()
	err = client.DoAction(request, response)
	return
}

// ListDictsWithChan invokes the elasticsearch.ListDicts API asynchronously
func (client *Client) ListDictsWithChan(request *ListDictsRequest) (<-chan *ListDictsResponse, <-chan error) {
	responseChan := make(chan *ListDictsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDicts(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDictsWithCallback invokes the elasticsearch.ListDicts API asynchronously
func (client *Client) ListDictsWithCallback(request *ListDictsRequest, callback func(response *ListDictsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDictsResponse
		var err error
		defer close(result)
		response, err = client.ListDicts(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDictsRequest is the request struct for api ListDicts
type ListDictsRequest struct {
	*requests.RoaRequest
	InstanceId   string `position:"Path" name:"InstanceId"`
	AnalyzerType string `position:"Query" name:"analyzerType"`
	Name         string `position:"Query" name:"name"`
}

// ListDictsResponse is the response struct for api ListDicts
type ListDictsResponse struct {
	*responses.BaseResponse
	RequestId string             `json:"RequestId" xml:"RequestId"`
	Headers   HeadersInListDicts `json:"Headers" xml:"Headers"`
	Result    []ResultItem       `json:"Result" xml:"Result"`
}

// CreateListDictsRequest creates a request to invoke ListDicts API
func CreateListDictsRequest() (request *ListDictsRequest) {
	request = &ListDictsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ListDicts", "/openapi/instances/[InstanceId]/dicts", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListDictsResponse creates a response to parse from ListDicts response
func CreateListDictsResponse() (response *ListDictsResponse) {
	response = &ListDictsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
