package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetClusterDataInformation invokes the elasticsearch.GetClusterDataInformation API synchronously
func (client *Client) GetClusterDataInformation(request *GetClusterDataInformationRequest) (response *GetClusterDataInformationResponse, err error) {
	response = CreateGetClusterDataInformationResponse()
	err = client.DoAction(request, response)
	return
}

// GetClusterDataInformationWithChan invokes the elasticsearch.GetClusterDataInformation API asynchronously
func (client *Client) GetClusterDataInformationWithChan(request *GetClusterDataInformationRequest) (<-chan *GetClusterDataInformationResponse, <-chan error) {
	responseChan := make(chan *GetClusterDataInformationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetClusterDataInformation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetClusterDataInformationWithCallback invokes the elasticsearch.GetClusterDataInformation API asynchronously
func (client *Client) GetClusterDataInformationWithCallback(request *GetClusterDataInformationRequest, callback func(response *GetClusterDataInformationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetClusterDataInformationResponse
		var err error
		defer close(result)
		response, err = client.GetClusterDataInformation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetClusterDataInformationRequest is the request struct for api GetClusterDataInformation
type GetClusterDataInformationRequest struct {
	*requests.RoaRequest
	Body string `position:"Body" name:"body"`
}

// GetClusterDataInformationResponse is the response struct for api GetClusterDataInformation
type GetClusterDataInformationResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateGetClusterDataInformationRequest creates a request to invoke GetClusterDataInformation API
func CreateGetClusterDataInformationRequest() (request *GetClusterDataInformationRequest) {
	request = &GetClusterDataInformationRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "GetClusterDataInformation", "/openapi/cluster/data-information", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetClusterDataInformationResponse creates a response to parse from GetClusterDataInformation response
func CreateGetClusterDataInformationResponse() (response *GetClusterDataInformationResponse) {
	response = &GetClusterDataInformationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
