package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDynamicSettings invokes the elasticsearch.DescribeDynamicSettings API synchronously
func (client *Client) DescribeDynamicSettings(request *DescribeDynamicSettingsRequest) (response *DescribeDynamicSettingsResponse, err error) {
	response = CreateDescribeDynamicSettingsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDynamicSettingsWithChan invokes the elasticsearch.DescribeDynamicSettings API asynchronously
func (client *Client) DescribeDynamicSettingsWithChan(request *DescribeDynamicSettingsRequest) (<-chan *DescribeDynamicSettingsResponse, <-chan error) {
	responseChan := make(chan *DescribeDynamicSettingsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDynamicSettings(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDynamicSettingsWithCallback invokes the elasticsearch.DescribeDynamicSettings API asynchronously
func (client *Client) DescribeDynamicSettingsWithCallback(request *DescribeDynamicSettingsRequest, callback func(response *DescribeDynamicSettingsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDynamicSettingsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDynamicSettings(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDynamicSettingsRequest is the request struct for api DescribeDynamicSettings
type DescribeDynamicSettingsRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// DescribeDynamicSettingsResponse is the response struct for api DescribeDynamicSettings
type DescribeDynamicSettingsResponse struct {
	*responses.BaseResponse
	Result    string `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDescribeDynamicSettingsRequest creates a request to invoke DescribeDynamicSettings API
func CreateDescribeDynamicSettingsRequest() (request *DescribeDynamicSettingsRequest) {
	request = &DescribeDynamicSettingsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "DescribeDynamicSettings", "/openapi/instances/[InstanceId]/dynamic-settings", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeDynamicSettingsResponse creates a response to parse from DescribeDynamicSettings response
func CreateDescribeDynamicSettingsResponse() (response *DescribeDynamicSettingsResponse) {
	response = &DescribeDynamicSettingsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
