package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreatePipelines invokes the elasticsearch.CreatePipelines API synchronously
func (client *Client) CreatePipelines(request *CreatePipelinesRequest) (response *CreatePipelinesResponse, err error) {
	response = CreateCreatePipelinesResponse()
	err = client.DoAction(request, response)
	return
}

// CreatePipelinesWithChan invokes the elasticsearch.CreatePipelines API asynchronously
func (client *Client) CreatePipelinesWithChan(request *CreatePipelinesRequest) (<-chan *CreatePipelinesResponse, <-chan error) {
	responseChan := make(chan *CreatePipelinesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreatePipelines(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreatePipelinesWithCallback invokes the elasticsearch.CreatePipelines API asynchronously
func (client *Client) CreatePipelinesWithCallback(request *CreatePipelinesRequest, callback func(response *CreatePipelinesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreatePipelinesResponse
		var err error
		defer close(result)
		response, err = client.CreatePipelines(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreatePipelinesRequest is the request struct for api CreatePipelines
type CreatePipelinesRequest struct {
	*requests.RoaRequest
	InstanceId  string           `position:"Path" name:"InstanceId"`
	ClientToken string           `position:"Query" name:"ClientToken"`
	Trigger     requests.Boolean `position:"Query" name:"trigger"`
	Body        string           `position:"Body" name:"body"`
}

// CreatePipelinesResponse is the response struct for api CreatePipelines
type CreatePipelinesResponse struct {
	*responses.BaseResponse
	Result    bool   `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreatePipelinesRequest creates a request to invoke CreatePipelines API
func CreateCreatePipelinesRequest() (request *CreatePipelinesRequest) {
	request = &CreatePipelinesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "CreatePipelines", "/openapi/logstashes/[InstanceId]/pipelines", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreatePipelinesResponse creates a response to parse from CreatePipelines response
func CreateCreatePipelinesResponse() (response *CreatePipelinesResponse) {
	response = &CreatePipelinesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
