package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListJobExecutors invokes the ehpc.ListJobExecutors API synchronously
func (client *Client) ListJobExecutors(request *ListJobExecutorsRequest) (response *ListJobExecutorsResponse, err error) {
	response = CreateListJobExecutorsResponse()
	err = client.DoAction(request, response)
	return
}

// ListJobExecutorsWithChan invokes the ehpc.ListJobExecutors API asynchronously
func (client *Client) ListJobExecutorsWithChan(request *ListJobExecutorsRequest) (<-chan *ListJobExecutorsResponse, <-chan error) {
	responseChan := make(chan *ListJobExecutorsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListJobExecutors(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListJobExecutorsWithCallback invokes the ehpc.ListJobExecutors API asynchronously
func (client *Client) ListJobExecutorsWithCallback(request *ListJobExecutorsRequest, callback func(response *ListJobExecutorsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListJobExecutorsResponse
		var err error
		defer close(result)
		response, err = client.ListJobExecutors(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListJobExecutorsRequest is the request struct for api ListJobExecutors
type ListJobExecutorsRequest struct {
	*requests.RpcRequest
	TaskName   string `position:"Query" name:"TaskName"`
	PageNumber string `position:"Query" name:"PageNumber"`
	JobId      string `position:"Query" name:"JobId"`
	PageSize   string `position:"Query" name:"PageSize"`
}

// ListJobExecutorsResponse is the response struct for api ListJobExecutors
type ListJobExecutorsResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	JobId      string     `json:"JobId" xml:"JobId"`
	TaskName   string     `json:"TaskName" xml:"TaskName"`
	PageSize   string     `json:"PageSize" xml:"PageSize"`
	PageNumber string     `json:"PageNumber" xml:"PageNumber"`
	TotalCount string     `json:"TotalCount" xml:"TotalCount"`
	Executors  []Executor `json:"Executors" xml:"Executors"`
}

// CreateListJobExecutorsRequest creates a request to invoke ListJobExecutors API
func CreateListJobExecutorsRequest() (request *ListJobExecutorsRequest) {
	request = &ListJobExecutorsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2023-07-01", "ListJobExecutors", "ehs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListJobExecutorsResponse creates a response to parse from ListJobExecutors response
func CreateListJobExecutorsResponse() (response *ListJobExecutorsResponse) {
	response = &ListJobExecutorsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
