package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateErAttachment invokes the eflo.UpdateErAttachment API synchronously
func (client *Client) UpdateErAttachment(request *UpdateErAttachmentRequest) (response *UpdateErAttachmentResponse, err error) {
	response = CreateUpdateErAttachmentResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateErAttachmentWithChan invokes the eflo.UpdateErAttachment API asynchronously
func (client *Client) UpdateErAttachmentWithChan(request *UpdateErAttachmentRequest) (<-chan *UpdateErAttachmentResponse, <-chan error) {
	responseChan := make(chan *UpdateErAttachmentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateErAttachment(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateErAttachmentWithCallback invokes the eflo.UpdateErAttachment API asynchronously
func (client *Client) UpdateErAttachmentWithCallback(request *UpdateErAttachmentRequest, callback func(response *UpdateErAttachmentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateErAttachmentResponse
		var err error
		defer close(result)
		response, err = client.UpdateErAttachment(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateErAttachmentRequest is the request struct for api UpdateErAttachment
type UpdateErAttachmentRequest struct {
	*requests.RpcRequest
	ErId             string `position:"Body" name:"ErId"`
	ErAttachmentId   string `position:"Body" name:"ErAttachmentId"`
	ErAttachmentName string `position:"Body" name:"ErAttachmentName"`
}

// UpdateErAttachmentResponse is the response struct for api UpdateErAttachment
type UpdateErAttachmentResponse struct {
	*responses.BaseResponse
	Code      int                    `json:"Code" xml:"Code"`
	Message   string                 `json:"Message" xml:"Message"`
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Content   map[string]interface{} `json:"Content" xml:"Content"`
}

// CreateUpdateErAttachmentRequest creates a request to invoke UpdateErAttachment API
func CreateUpdateErAttachmentRequest() (request *UpdateErAttachmentRequest) {
	request = &UpdateErAttachmentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "UpdateErAttachment", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateErAttachmentResponse creates a response to parse from UpdateErAttachment response
func CreateUpdateErAttachmentResponse() (response *UpdateErAttachmentResponse) {
	response = &UpdateErAttachmentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
