package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeSlr invokes the eflo.DescribeSlr API synchronously
func (client *Client) DescribeSlr(request *DescribeSlrRequest) (response *DescribeSlrResponse, err error) {
	response = CreateDescribeSlrResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeSlrWithChan invokes the eflo.DescribeSlr API asynchronously
func (client *Client) DescribeSlrWithChan(request *DescribeSlrRequest) (<-chan *DescribeSlrResponse, <-chan error) {
	responseChan := make(chan *DescribeSlrResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeSlr(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeSlrWithCallback invokes the eflo.DescribeSlr API asynchronously
func (client *Client) DescribeSlrWithCallback(request *DescribeSlrRequest, callback func(response *DescribeSlrResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeSlrResponse
		var err error
		defer close(result)
		response, err = client.DescribeSlr(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeSlrRequest is the request struct for api DescribeSlr
type DescribeSlrRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Body" name:"ResourceGroupId"`
}

// DescribeSlrResponse is the response struct for api DescribeSlr
type DescribeSlrResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateDescribeSlrRequest creates a request to invoke DescribeSlr API
func CreateDescribeSlrRequest() (request *DescribeSlrRequest) {
	request = &DescribeSlrRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "DescribeSlr", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeSlrResponse creates a response to parse from DescribeSlr response
func CreateDescribeSlrResponse() (response *DescribeSlrResponse) {
	response = &DescribeSlrResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
