package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateEr invokes the eflo.CreateEr API synchronously
func (client *Client) CreateEr(request *CreateErRequest) (response *CreateErResponse, err error) {
	response = CreateCreateErResponse()
	err = client.DoAction(request, response)
	return
}

// CreateErWithChan invokes the eflo.CreateEr API asynchronously
func (client *Client) CreateErWithChan(request *CreateErRequest) (<-chan *CreateErResponse, <-chan error) {
	responseChan := make(chan *CreateErResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateEr(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateErWithCallback invokes the eflo.CreateEr API asynchronously
func (client *Client) CreateErWithCallback(request *CreateErRequest, callback func(response *CreateErResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateErResponse
		var err error
		defer close(result)
		response, err = client.CreateEr(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateErRequest is the request struct for api CreateEr
type CreateErRequest struct {
	*requests.RpcRequest
	Description     string `position:"Body" name:"Description"`
	ErName          string `position:"Body" name:"ErName"`
	MasterZoneId    string `position:"Body" name:"MasterZoneId"`
	ResourceGroupId string `position:"Body" name:"ResourceGroupId"`
}

// CreateErResponse is the response struct for api CreateEr
type CreateErResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateCreateErRequest creates a request to invoke CreateEr API
func CreateCreateErRequest() (request *CreateErRequest) {
	request = &CreateErRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "CreateEr", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateErResponse creates a response to parse from CreateEr response
func CreateCreateErResponse() (response *CreateErResponse) {
	response = &CreateErResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
