package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteLogPath invokes the edas.DeleteLogPath API synchronously
func (client *Client) DeleteLogPath(request *DeleteLogPathRequest) (response *DeleteLogPathResponse, err error) {
	response = CreateDeleteLogPathResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteLogPathWithChan invokes the edas.DeleteLogPath API asynchronously
func (client *Client) DeleteLogPathWithChan(request *DeleteLogPathRequest) (<-chan *DeleteLogPathResponse, <-chan error) {
	responseChan := make(chan *DeleteLogPathResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteLogPath(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteLogPathWithCallback invokes the edas.DeleteLogPath API asynchronously
func (client *Client) DeleteLogPathWithCallback(request *DeleteLogPathRequest, callback func(response *DeleteLogPathResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteLogPathResponse
		var err error
		defer close(result)
		response, err = client.DeleteLogPath(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteLogPathRequest is the request struct for api DeleteLogPath
type DeleteLogPathRequest struct {
	*requests.RoaRequest
	Path  string `position:"Query" name:"Path"`
	AppId string `position:"Query" name:"AppId"`
}

// DeleteLogPathResponse is the response struct for api DeleteLogPath
type DeleteLogPathResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteLogPathRequest creates a request to invoke DeleteLogPath API
func CreateDeleteLogPathRequest() (request *DeleteLogPathRequest) {
	request = &DeleteLogPathRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "DeleteLogPath", "/pop/v5/log/popListLogDirs", "Edas", "openAPI")
	request.Method = requests.DELETE
	return
}

// CreateDeleteLogPathResponse creates a response to parse from DeleteLogPath response
func CreateDeleteLogPathResponse() (response *DeleteLogPathResponse) {
	response = &DeleteLogPathResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
