package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDesktopOversoldGroupSale invokes the ecd.ModifyDesktopOversoldGroupSale API synchronously
func (client *Client) ModifyDesktopOversoldGroupSale(request *ModifyDesktopOversoldGroupSaleRequest) (response *ModifyDesktopOversoldGroupSaleResponse, err error) {
	response = CreateModifyDesktopOversoldGroupSaleResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDesktopOversoldGroupSaleWithChan invokes the ecd.ModifyDesktopOversoldGroupSale API asynchronously
func (client *Client) ModifyDesktopOversoldGroupSaleWithChan(request *ModifyDesktopOversoldGroupSaleRequest) (<-chan *ModifyDesktopOversoldGroupSaleResponse, <-chan error) {
	responseChan := make(chan *ModifyDesktopOversoldGroupSaleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDesktopOversoldGroupSale(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDesktopOversoldGroupSaleWithCallback invokes the ecd.ModifyDesktopOversoldGroupSale API asynchronously
func (client *Client) ModifyDesktopOversoldGroupSaleWithCallback(request *ModifyDesktopOversoldGroupSaleRequest, callback func(response *ModifyDesktopOversoldGroupSaleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDesktopOversoldGroupSaleResponse
		var err error
		defer close(result)
		response, err = client.ModifyDesktopOversoldGroupSale(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDesktopOversoldGroupSaleRequest is the request struct for api ModifyDesktopOversoldGroupSale
type ModifyDesktopOversoldGroupSaleRequest struct {
	*requests.RpcRequest
	OversoldGroupId   string           `position:"Query" name:"OversoldGroupId"`
	OversoldUserCount requests.Integer `position:"Query" name:"OversoldUserCount"`
	ConcurrenceCount  requests.Integer `position:"Query" name:"ConcurrenceCount"`
}

// ModifyDesktopOversoldGroupSaleResponse is the response struct for api ModifyDesktopOversoldGroupSale
type ModifyDesktopOversoldGroupSaleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateModifyDesktopOversoldGroupSaleRequest creates a request to invoke ModifyDesktopOversoldGroupSale API
func CreateModifyDesktopOversoldGroupSaleRequest() (request *ModifyDesktopOversoldGroupSaleRequest) {
	request = &ModifyDesktopOversoldGroupSaleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ModifyDesktopOversoldGroupSale", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDesktopOversoldGroupSaleResponse creates a response to parse from ModifyDesktopOversoldGroupSale response
func CreateModifyDesktopOversoldGroupSaleResponse() (response *ModifyDesktopOversoldGroupSaleResponse) {
	response = &ModifyDesktopOversoldGroupSaleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
