package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyCdsFile invokes the ecd.ModifyCdsFile API synchronously
func (client *Client) ModifyCdsFile(request *ModifyCdsFileRequest) (response *ModifyCdsFileResponse, err error) {
	response = CreateModifyCdsFileResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyCdsFileWithChan invokes the ecd.ModifyCdsFile API asynchronously
func (client *Client) ModifyCdsFileWithChan(request *ModifyCdsFileRequest) (<-chan *ModifyCdsFileResponse, <-chan error) {
	responseChan := make(chan *ModifyCdsFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyCdsFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyCdsFileWithCallback invokes the ecd.ModifyCdsFile API asynchronously
func (client *Client) ModifyCdsFileWithCallback(request *ModifyCdsFileRequest, callback func(response *ModifyCdsFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyCdsFileResponse
		var err error
		defer close(result)
		response, err = client.ModifyCdsFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyCdsFileRequest is the request struct for api ModifyCdsFile
type ModifyCdsFileRequest struct {
	*requests.RpcRequest
	GroupId        string `position:"Query" name:"GroupId"`
	CdsId          string `position:"Query" name:"CdsId"`
	ConflictPolicy string `position:"Query" name:"ConflictPolicy"`
	FileName       string `position:"Query" name:"FileName"`
	EndUserId      string `position:"Query" name:"EndUserId"`
	FileId         string `position:"Query" name:"FileId"`
}

// ModifyCdsFileResponse is the response struct for api ModifyCdsFile
type ModifyCdsFileResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateModifyCdsFileRequest creates a request to invoke ModifyCdsFile API
func CreateModifyCdsFileRequest() (request *ModifyCdsFileRequest) {
	request = &ModifyCdsFileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ModifyCdsFile", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyCdsFileResponse creates a response to parse from ModifyCdsFile response
func CreateModifyCdsFileResponse() (response *ModifyCdsFileResponse) {
	response = &ModifyCdsFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
