package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeImageModifiedRecords invokes the ecd.DescribeImageModifiedRecords API synchronously
func (client *Client) DescribeImageModifiedRecords(request *DescribeImageModifiedRecordsRequest) (response *DescribeImageModifiedRecordsResponse, err error) {
	response = CreateDescribeImageModifiedRecordsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeImageModifiedRecordsWithChan invokes the ecd.DescribeImageModifiedRecords API asynchronously
func (client *Client) DescribeImageModifiedRecordsWithChan(request *DescribeImageModifiedRecordsRequest) (<-chan *DescribeImageModifiedRecordsResponse, <-chan error) {
	responseChan := make(chan *DescribeImageModifiedRecordsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeImageModifiedRecords(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeImageModifiedRecordsWithCallback invokes the ecd.DescribeImageModifiedRecords API asynchronously
func (client *Client) DescribeImageModifiedRecordsWithCallback(request *DescribeImageModifiedRecordsRequest, callback func(response *DescribeImageModifiedRecordsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeImageModifiedRecordsResponse
		var err error
		defer close(result)
		response, err = client.DescribeImageModifiedRecords(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeImageModifiedRecordsRequest is the request struct for api DescribeImageModifiedRecords
type DescribeImageModifiedRecordsRequest struct {
	*requests.RpcRequest
	NextToken  string           `position:"Query" name:"NextToken"`
	MaxResults requests.Integer `position:"Query" name:"MaxResults"`
	DesktopId  string           `position:"Query" name:"DesktopId"`
}

// DescribeImageModifiedRecordsResponse is the response struct for api DescribeImageModifiedRecords
type DescribeImageModifiedRecordsResponse struct {
	*responses.BaseResponse
	NextToken            string                `json:"NextToken" xml:"NextToken"`
	RequestId            string                `json:"RequestId" xml:"RequestId"`
	TotalCount           int                   `json:"TotalCount" xml:"TotalCount"`
	ImageModifiedRecords []ImageModifiedRecord `json:"ImageModifiedRecords" xml:"ImageModifiedRecords"`
}

// CreateDescribeImageModifiedRecordsRequest creates a request to invoke DescribeImageModifiedRecords API
func CreateDescribeImageModifiedRecordsRequest() (request *DescribeImageModifiedRecordsRequest) {
	request = &DescribeImageModifiedRecordsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeImageModifiedRecords", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeImageModifiedRecordsResponse creates a response to parse from DescribeImageModifiedRecords response
func CreateDescribeImageModifiedRecordsResponse() (response *DescribeImageModifiedRecordsResponse) {
	response = &DescribeImageModifiedRecordsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
