package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateCdsFile invokes the ecd.CreateCdsFile API synchronously
func (client *Client) CreateCdsFile(request *CreateCdsFileRequest) (response *CreateCdsFileResponse, err error) {
	response = CreateCreateCdsFileResponse()
	err = client.DoAction(request, response)
	return
}

// CreateCdsFileWithChan invokes the ecd.CreateCdsFile API asynchronously
func (client *Client) CreateCdsFileWithChan(request *CreateCdsFileRequest) (<-chan *CreateCdsFileResponse, <-chan error) {
	responseChan := make(chan *CreateCdsFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateCdsFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateCdsFileWithCallback invokes the ecd.CreateCdsFile API asynchronously
func (client *Client) CreateCdsFileWithCallback(request *CreateCdsFileRequest, callback func(response *CreateCdsFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateCdsFileResponse
		var err error
		defer close(result)
		response, err = client.CreateCdsFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateCdsFileRequest is the request struct for api CreateCdsFile
type CreateCdsFileRequest struct {
	*requests.RpcRequest
	FileType       string           `position:"Query" name:"FileType"`
	FileLength     requests.Integer `position:"Query" name:"FileLength"`
	EndUserId      string           `position:"Query" name:"EndUserId"`
	GroupId        string           `position:"Query" name:"GroupId"`
	CdsId          string           `position:"Query" name:"CdsId"`
	ConflictPolicy string           `position:"Query" name:"ConflictPolicy"`
	ParentFileId   string           `position:"Query" name:"ParentFileId"`
	FileName       string           `position:"Query" name:"FileName"`
	FileHash       string           `position:"Query" name:"FileHash"`
}

// CreateCdsFileResponse is the response struct for api CreateCdsFile
type CreateCdsFileResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	FileModel FileModel `json:"FileModel" xml:"FileModel"`
}

// CreateCreateCdsFileRequest creates a request to invoke CreateCdsFile API
func CreateCreateCdsFileRequest() (request *CreateCdsFileRequest) {
	request = &CreateCdsFileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "CreateCdsFile", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateCdsFileResponse creates a response to parse from CreateCdsFile response
func CreateCreateCdsFileResponse() (response *CreateCdsFileResponse) {
	response = &CreateCdsFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
