package ebs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// FailoverDiskReplicaGroup invokes the ebs.FailoverDiskReplicaGroup API synchronously
func (client *Client) FailoverDiskReplicaGroup(request *FailoverDiskReplicaGroupRequest) (response *FailoverDiskReplicaGroupResponse, err error) {
	response = CreateFailoverDiskReplicaGroupResponse()
	err = client.DoAction(request, response)
	return
}

// FailoverDiskReplicaGroupWithChan invokes the ebs.FailoverDiskReplicaGroup API asynchronously
func (client *Client) FailoverDiskReplicaGroupWithChan(request *FailoverDiskReplicaGroupRequest) (<-chan *FailoverDiskReplicaGroupResponse, <-chan error) {
	responseChan := make(chan *FailoverDiskReplicaGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.FailoverDiskReplicaGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// FailoverDiskReplicaGroupWithCallback invokes the ebs.FailoverDiskReplicaGroup API asynchronously
func (client *Client) FailoverDiskReplicaGroupWithCallback(request *FailoverDiskReplicaGroupRequest, callback func(response *FailoverDiskReplicaGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *FailoverDiskReplicaGroupResponse
		var err error
		defer close(result)
		response, err = client.FailoverDiskReplicaGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// FailoverDiskReplicaGroupRequest is the request struct for api FailoverDiskReplicaGroup
type FailoverDiskReplicaGroupRequest struct {
	*requests.RpcRequest
	ClientToken    string `position:"Query" name:"ClientToken"`
	ReplicaGroupId string `position:"Query" name:"ReplicaGroupId"`
}

// FailoverDiskReplicaGroupResponse is the response struct for api FailoverDiskReplicaGroup
type FailoverDiskReplicaGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateFailoverDiskReplicaGroupRequest creates a request to invoke FailoverDiskReplicaGroup API
func CreateFailoverDiskReplicaGroupRequest() (request *FailoverDiskReplicaGroupRequest) {
	request = &FailoverDiskReplicaGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ebs", "2021-07-30", "FailoverDiskReplicaGroup", "ebs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateFailoverDiskReplicaGroupResponse creates a response to parse from FailoverDiskReplicaGroup response
func CreateFailoverDiskReplicaGroupResponse() (response *FailoverDiskReplicaGroupResponse) {
	response = &FailoverDiskReplicaGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
