package dysmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryCardSmsTemplate invokes the dysmsapi.QueryCardSmsTemplate API synchronously
func (client *Client) QueryCardSmsTemplate(request *QueryCardSmsTemplateRequest) (response *QueryCardSmsTemplateResponse, err error) {
	response = CreateQueryCardSmsTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// QueryCardSmsTemplateWithChan invokes the dysmsapi.QueryCardSmsTemplate API asynchronously
func (client *Client) QueryCardSmsTemplateWithChan(request *QueryCardSmsTemplateRequest) (<-chan *QueryCardSmsTemplateResponse, <-chan error) {
	responseChan := make(chan *QueryCardSmsTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryCardSmsTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryCardSmsTemplateWithCallback invokes the dysmsapi.QueryCardSmsTemplate API asynchronously
func (client *Client) QueryCardSmsTemplateWithCallback(request *QueryCardSmsTemplateRequest, callback func(response *QueryCardSmsTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryCardSmsTemplateResponse
		var err error
		defer close(result)
		response, err = client.QueryCardSmsTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryCardSmsTemplateRequest is the request struct for api QueryCardSmsTemplate
type QueryCardSmsTemplateRequest struct {
	*requests.RpcRequest
	ProductCode     string           `position:"Query" name:"ProductCode"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TemplateCode    string           `position:"Query" name:"TemplateCode"`
}

// QueryCardSmsTemplateResponse is the response struct for api QueryCardSmsTemplate
type QueryCardSmsTemplateResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateQueryCardSmsTemplateRequest creates a request to invoke QueryCardSmsTemplate API
func CreateQueryCardSmsTemplateRequest() (request *QueryCardSmsTemplateRequest) {
	request = &QueryCardSmsTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dysmsapi", "2017-05-25", "QueryCardSmsTemplate", "dysms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryCardSmsTemplateResponse creates a response to parse from QueryCardSmsTemplate response
func CreateQueryCardSmsTemplateResponse() (response *QueryCardSmsTemplateResponse) {
	response = &QueryCardSmsTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
