package dysmsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BatchSendMessageToGlobe invokes the dysmsapi.BatchSendMessageToGlobe API synchronously
func (client *Client) BatchSendMessageToGlobe(request *BatchSendMessageToGlobeRequest) (response *BatchSendMessageToGlobeResponse, err error) {
	response = CreateBatchSendMessageToGlobeResponse()
	err = client.DoAction(request, response)
	return
}

// BatchSendMessageToGlobeWithChan invokes the dysmsapi.BatchSendMessageToGlobe API asynchronously
func (client *Client) BatchSendMessageToGlobeWithChan(request *BatchSendMessageToGlobeRequest) (<-chan *BatchSendMessageToGlobeResponse, <-chan error) {
	responseChan := make(chan *BatchSendMessageToGlobeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BatchSendMessageToGlobe(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BatchSendMessageToGlobeWithCallback invokes the dysmsapi.BatchSendMessageToGlobe API asynchronously
func (client *Client) BatchSendMessageToGlobeWithCallback(request *BatchSendMessageToGlobeRequest, callback func(response *BatchSendMessageToGlobeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BatchSendMessageToGlobeResponse
		var err error
		defer close(result)
		response, err = client.BatchSendMessageToGlobe(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BatchSendMessageToGlobeRequest is the request struct for api BatchSendMessageToGlobe
type BatchSendMessageToGlobeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Type                 string           `position:"Query" name:"Type"`
	From                 string           `position:"Query" name:"From"`
	TaskId               string           `position:"Query" name:"TaskId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	Message              string           `position:"Query" name:"Message"`
	ValidityPeriod       requests.Integer `position:"Query" name:"ValidityPeriod"`
	To                   string           `position:"Query" name:"To"`
	ChannelId            string           `position:"Query" name:"ChannelId"`
}

// BatchSendMessageToGlobeResponse is the response struct for api BatchSendMessageToGlobe
type BatchSendMessageToGlobeResponse struct {
	*responses.BaseResponse
	ResponseCode        string `json:"ResponseCode" xml:"ResponseCode"`
	RequestId           string `json:"RequestId" xml:"RequestId"`
	FailedList          string `json:"FailedList" xml:"FailedList"`
	ResponseDescription string `json:"ResponseDescription" xml:"ResponseDescription"`
	From                string `json:"From" xml:"From"`
	MessageIdList       string `json:"MessageIdList" xml:"MessageIdList"`
	SuccessCount        string `json:"SuccessCount" xml:"SuccessCount"`
}

// CreateBatchSendMessageToGlobeRequest creates a request to invoke BatchSendMessageToGlobe API
func CreateBatchSendMessageToGlobeRequest() (request *BatchSendMessageToGlobeRequest) {
	request = &BatchSendMessageToGlobeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dysmsapi", "2018-05-01", "BatchSendMessageToGlobe", "dysms", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBatchSendMessageToGlobeResponse creates a response to parse from BatchSendMessageToGlobe response
func CreateBatchSendMessageToGlobeResponse() (response *BatchSendMessageToGlobeResponse) {
	response = &BatchSendMessageToGlobeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
