package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyAccountPrivilege invokes the drds.ModifyAccountPrivilege API synchronously
func (client *Client) ModifyAccountPrivilege(request *ModifyAccountPrivilegeRequest) (response *ModifyAccountPrivilegeResponse, err error) {
	response = CreateModifyAccountPrivilegeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyAccountPrivilegeWithChan invokes the drds.ModifyAccountPrivilege API asynchronously
func (client *Client) ModifyAccountPrivilegeWithChan(request *ModifyAccountPrivilegeRequest) (<-chan *ModifyAccountPrivilegeResponse, <-chan error) {
	responseChan := make(chan *ModifyAccountPrivilegeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyAccountPrivilege(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyAccountPrivilegeWithCallback invokes the drds.ModifyAccountPrivilege API asynchronously
func (client *Client) ModifyAccountPrivilegeWithCallback(request *ModifyAccountPrivilegeRequest, callback func(response *ModifyAccountPrivilegeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyAccountPrivilegeResponse
		var err error
		defer close(result)
		response, err = client.ModifyAccountPrivilege(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyAccountPrivilegeRequest is the request struct for api ModifyAccountPrivilege
type ModifyAccountPrivilegeRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string                               `position:"Query" name:"DrdsInstanceId"`
	AccountName    string                               `position:"Query" name:"AccountName"`
	DbPrivilege    *[]ModifyAccountPrivilegeDbPrivilege `position:"Query" name:"DbPrivilege"  type:"Repeated"`
}

// ModifyAccountPrivilegeDbPrivilege is a repeated param struct in ModifyAccountPrivilegeRequest
type ModifyAccountPrivilegeDbPrivilege struct {
	DbName    string `name:"DbName"`
	Privilege string `name:"Privilege"`
}

// ModifyAccountPrivilegeResponse is the response struct for api ModifyAccountPrivilege
type ModifyAccountPrivilegeResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyAccountPrivilegeRequest creates a request to invoke ModifyAccountPrivilege API
func CreateModifyAccountPrivilegeRequest() (request *ModifyAccountPrivilegeRequest) {
	request = &ModifyAccountPrivilegeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "ModifyAccountPrivilege", "drds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyAccountPrivilegeResponse creates a response to parse from ModifyAccountPrivilege response
func CreateModifyAccountPrivilegeResponse() (response *ModifyAccountPrivilegeResponse) {
	response = &ModifyAccountPrivilegeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
