package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeExpandLogicTableInfoList invokes the drds.DescribeExpandLogicTableInfoList API synchronously
func (client *Client) DescribeExpandLogicTableInfoList(request *DescribeExpandLogicTableInfoListRequest) (response *DescribeExpandLogicTableInfoListResponse, err error) {
	response = CreateDescribeExpandLogicTableInfoListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeExpandLogicTableInfoListWithChan invokes the drds.DescribeExpandLogicTableInfoList API asynchronously
func (client *Client) DescribeExpandLogicTableInfoListWithChan(request *DescribeExpandLogicTableInfoListRequest) (<-chan *DescribeExpandLogicTableInfoListResponse, <-chan error) {
	responseChan := make(chan *DescribeExpandLogicTableInfoListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeExpandLogicTableInfoList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeExpandLogicTableInfoListWithCallback invokes the drds.DescribeExpandLogicTableInfoList API asynchronously
func (client *Client) DescribeExpandLogicTableInfoListWithCallback(request *DescribeExpandLogicTableInfoListRequest, callback func(response *DescribeExpandLogicTableInfoListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeExpandLogicTableInfoListResponse
		var err error
		defer close(result)
		response, err = client.DescribeExpandLogicTableInfoList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeExpandLogicTableInfoListRequest is the request struct for api DescribeExpandLogicTableInfoList
type DescribeExpandLogicTableInfoListRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	DbName         string `position:"Query" name:"DbName"`
}

// DescribeExpandLogicTableInfoListResponse is the response struct for api DescribeExpandLogicTableInfoList
type DescribeExpandLogicTableInfoListResponse struct {
	*responses.BaseResponse
	Success   bool                                   `json:"Success" xml:"Success"`
	RequestId string                                 `json:"RequestId" xml:"RequestId"`
	Data      DataInDescribeExpandLogicTableInfoList `json:"Data" xml:"Data"`
}

// CreateDescribeExpandLogicTableInfoListRequest creates a request to invoke DescribeExpandLogicTableInfoList API
func CreateDescribeExpandLogicTableInfoListRequest() (request *DescribeExpandLogicTableInfoListRequest) {
	request = &DescribeExpandLogicTableInfoListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "DescribeExpandLogicTableInfoList", "drds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeExpandLogicTableInfoListResponse creates a response to parse from DescribeExpandLogicTableInfoList response
func CreateDescribeExpandLogicTableInfoListResponse() (response *DescribeExpandLogicTableInfoListResponse) {
	response = &DescribeExpandLogicTableInfoListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
