package documentautoml

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetModelAsyncPredict invokes the documentautoml.GetModelAsyncPredict API synchronously
func (client *Client) GetModelAsyncPredict(request *GetModelAsyncPredictRequest) (response *GetModelAsyncPredictResponse, err error) {
	response = CreateGetModelAsyncPredictResponse()
	err = client.DoAction(request, response)
	return
}

// GetModelAsyncPredictWithChan invokes the documentautoml.GetModelAsyncPredict API asynchronously
func (client *Client) GetModelAsyncPredictWithChan(request *GetModelAsyncPredictRequest) (<-chan *GetModelAsyncPredictResponse, <-chan error) {
	responseChan := make(chan *GetModelAsyncPredictResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetModelAsyncPredict(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetModelAsyncPredictWithCallback invokes the documentautoml.GetModelAsyncPredict API asynchronously
func (client *Client) GetModelAsyncPredictWithCallback(request *GetModelAsyncPredictRequest, callback func(response *GetModelAsyncPredictResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetModelAsyncPredictResponse
		var err error
		defer close(result)
		response, err = client.GetModelAsyncPredict(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetModelAsyncPredictRequest is the request struct for api GetModelAsyncPredict
type GetModelAsyncPredictRequest struct {
	*requests.RpcRequest
	AsyncPredictId requests.Integer `position:"Query" name:"AsyncPredictId"`
	Product        string           `position:"Query" name:"Product"`
}

// GetModelAsyncPredictResponse is the response struct for api GetModelAsyncPredict
type GetModelAsyncPredictResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetModelAsyncPredictRequest creates a request to invoke GetModelAsyncPredict API
func CreateGetModelAsyncPredictRequest() (request *GetModelAsyncPredictRequest) {
	request = &GetModelAsyncPredictRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("documentAutoml", "2022-12-29", "GetModelAsyncPredict", "documentAutoml", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetModelAsyncPredictResponse creates a response to parse from GetModelAsyncPredict response
func CreateGetModelAsyncPredictResponse() (response *GetModelAsyncPredictResponse) {
	response = &GetModelAsyncPredictResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
