package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateTaskConfig invokes the dms_enterprise.UpdateTaskConfig API synchronously
func (client *Client) UpdateTaskConfig(request *UpdateTaskConfigRequest) (response *UpdateTaskConfigResponse, err error) {
	response = CreateUpdateTaskConfigResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateTaskConfigWithChan invokes the dms_enterprise.UpdateTaskConfig API asynchronously
func (client *Client) UpdateTaskConfigWithChan(request *UpdateTaskConfigRequest) (<-chan *UpdateTaskConfigResponse, <-chan error) {
	responseChan := make(chan *UpdateTaskConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateTaskConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateTaskConfigWithCallback invokes the dms_enterprise.UpdateTaskConfig API asynchronously
func (client *Client) UpdateTaskConfigWithCallback(request *UpdateTaskConfigRequest, callback func(response *UpdateTaskConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateTaskConfigResponse
		var err error
		defer close(result)
		response, err = client.UpdateTaskConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateTaskConfigRequest is the request struct for api UpdateTaskConfig
type UpdateTaskConfigRequest struct {
	*requests.RpcRequest
	NodeConfig string           `position:"Query" name:"NodeConfig"`
	Tid        requests.Integer `position:"Query" name:"Tid"`
	NodeId     string           `position:"Query" name:"NodeId"`
}

// UpdateTaskConfigResponse is the response struct for api UpdateTaskConfig
type UpdateTaskConfigResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateUpdateTaskConfigRequest creates a request to invoke UpdateTaskConfig API
func CreateUpdateTaskConfigRequest() (request *UpdateTaskConfigRequest) {
	request = &UpdateTaskConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "UpdateTaskConfig", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateTaskConfigResponse creates a response to parse from UpdateTaskConfig response
func CreateUpdateTaskConfigResponse() (response *UpdateTaskConfigResponse) {
	response = &UpdateTaskConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
