package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAuthorityTemplate invokes the dms_enterprise.DeleteAuthorityTemplate API synchronously
func (client *Client) DeleteAuthorityTemplate(request *DeleteAuthorityTemplateRequest) (response *DeleteAuthorityTemplateResponse, err error) {
	response = CreateDeleteAuthorityTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAuthorityTemplateWithChan invokes the dms_enterprise.DeleteAuthorityTemplate API asynchronously
func (client *Client) DeleteAuthorityTemplateWithChan(request *DeleteAuthorityTemplateRequest) (<-chan *DeleteAuthorityTemplateResponse, <-chan error) {
	responseChan := make(chan *DeleteAuthorityTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAuthorityTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAuthorityTemplateWithCallback invokes the dms_enterprise.DeleteAuthorityTemplate API asynchronously
func (client *Client) DeleteAuthorityTemplateWithCallback(request *DeleteAuthorityTemplateRequest, callback func(response *DeleteAuthorityTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAuthorityTemplateResponse
		var err error
		defer close(result)
		response, err = client.DeleteAuthorityTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAuthorityTemplateRequest is the request struct for api DeleteAuthorityTemplate
type DeleteAuthorityTemplateRequest struct {
	*requests.RpcRequest
	Tid        requests.Integer `position:"Query" name:"Tid"`
	TemplateId requests.Integer `position:"Query" name:"TemplateId"`
}

// DeleteAuthorityTemplateResponse is the response struct for api DeleteAuthorityTemplate
type DeleteAuthorityTemplateResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ErrorCode    string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	Success      bool   `json:"Success" xml:"Success"`
	Tid          int64  `json:"Tid" xml:"Tid"`
}

// CreateDeleteAuthorityTemplateRequest creates a request to invoke DeleteAuthorityTemplate API
func CreateDeleteAuthorityTemplateRequest() (request *DeleteAuthorityTemplateRequest) {
	request = &DeleteAuthorityTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "DeleteAuthorityTemplate", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteAuthorityTemplateResponse creates a response to parse from DeleteAuthorityTemplate response
func CreateDeleteAuthorityTemplateResponse() (response *DeleteAuthorityTemplateResponse) {
	response = &DeleteAuthorityTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
