package dms_dg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUserDatabases invokes the dms_dg.GetUserDatabases API synchronously
func (client *Client) GetUserDatabases(request *GetUserDatabasesRequest) (response *GetUserDatabasesResponse, err error) {
	response = CreateGetUserDatabasesResponse()
	err = client.DoAction(request, response)
	return
}

// GetUserDatabasesWithChan invokes the dms_dg.GetUserDatabases API asynchronously
func (client *Client) GetUserDatabasesWithChan(request *GetUserDatabasesRequest) (<-chan *GetUserDatabasesResponse, <-chan error) {
	responseChan := make(chan *GetUserDatabasesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUserDatabases(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUserDatabasesWithCallback invokes the dms_dg.GetUserDatabases API asynchronously
func (client *Client) GetUserDatabasesWithCallback(request *GetUserDatabasesRequest, callback func(response *GetUserDatabasesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUserDatabasesResponse
		var err error
		defer close(result)
		response, err = client.GetUserDatabases(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUserDatabasesRequest is the request struct for api GetUserDatabases
type GetUserDatabasesRequest struct {
	*requests.RpcRequest
	SearchKey  string           `position:"Body" name:"SearchKey"`
	PageNumber string           `position:"Body" name:"PageNumber"`
	PageSize   string           `position:"Body" name:"PageSize"`
	Host       string           `position:"Body" name:"Host"`
	GatewayId  string           `position:"Body" name:"GatewayId"`
	InstanceId string           `position:"Body" name:"InstanceId"`
	Port       requests.Integer `position:"Body" name:"Port"`
	DbType     string           `position:"Body" name:"DbType"`
}

// GetUserDatabasesResponse is the response struct for api GetUserDatabases
type GetUserDatabasesResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	Success        string         `json:"Success" xml:"Success"`
	Code           string         `json:"Code" xml:"Code"`
	ErrorMsg       string         `json:"ErrorMsg" xml:"ErrorMsg"`
	Count          int            `json:"Count" xml:"Count"`
	DbInstanceList DbInstanceList `json:"DbInstanceList" xml:"DbInstanceList"`
}

// CreateGetUserDatabasesRequest creates a request to invoke GetUserDatabases API
func CreateGetUserDatabasesRequest() (request *GetUserDatabasesRequest) {
	request = &GetUserDatabasesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-dg", "2023-09-14", "GetUserDatabases", "", "")
	request.Method = requests.POST
	return
}

// CreateGetUserDatabasesResponse creates a response to parse from GetUserDatabases response
func CreateGetUserDatabasesResponse() (response *GetUserDatabasesResponse) {
	response = &GetUserDatabasesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
