package dms_dg

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DownloadGatewayProgram invokes the dms_dg.DownloadGatewayProgram API synchronously
func (client *Client) DownloadGatewayProgram(request *DownloadGatewayProgramRequest) (response *DownloadGatewayProgramResponse, err error) {
	response = CreateDownloadGatewayProgramResponse()
	err = client.DoAction(request, response)
	return
}

// DownloadGatewayProgramWithChan invokes the dms_dg.DownloadGatewayProgram API asynchronously
func (client *Client) DownloadGatewayProgramWithChan(request *DownloadGatewayProgramRequest) (<-chan *DownloadGatewayProgramResponse, <-chan error) {
	responseChan := make(chan *DownloadGatewayProgramResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DownloadGatewayProgram(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DownloadGatewayProgramWithCallback invokes the dms_dg.DownloadGatewayProgram API asynchronously
func (client *Client) DownloadGatewayProgramWithCallback(request *DownloadGatewayProgramRequest, callback func(response *DownloadGatewayProgramResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DownloadGatewayProgramResponse
		var err error
		defer close(result)
		response, err = client.DownloadGatewayProgram(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DownloadGatewayProgramRequest is the request struct for api DownloadGatewayProgram
type DownloadGatewayProgramRequest struct {
	*requests.RpcRequest
	UserOS    string `position:"Body" name:"UserOS"`
	DgVersion string `position:"Body" name:"DgVersion"`
}

// DownloadGatewayProgramResponse is the response struct for api DownloadGatewayProgram
type DownloadGatewayProgramResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Data      string `json:"Data" xml:"Data"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateDownloadGatewayProgramRequest creates a request to invoke DownloadGatewayProgram API
func CreateDownloadGatewayProgramRequest() (request *DownloadGatewayProgramRequest) {
	request = &DownloadGatewayProgramRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-dg", "2023-09-14", "DownloadGatewayProgram", "", "")
	request.Method = requests.POST
	return
}

// CreateDownloadGatewayProgramResponse creates a response to parse from DownloadGatewayProgram response
func CreateDownloadGatewayProgramResponse() (response *DownloadGatewayProgramResponse) {
	response = &DownloadGatewayProgramResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
