package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyQpsMode invokes the ddoscoo.ModifyQpsMode API synchronously
func (client *Client) ModifyQpsMode(request *ModifyQpsModeRequest) (response *ModifyQpsModeResponse, err error) {
	response = CreateModifyQpsModeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyQpsModeWithChan invokes the ddoscoo.ModifyQpsMode API asynchronously
func (client *Client) ModifyQpsModeWithChan(request *ModifyQpsModeRequest) (<-chan *ModifyQpsModeResponse, <-chan error) {
	responseChan := make(chan *ModifyQpsModeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyQpsMode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyQpsModeWithCallback invokes the ddoscoo.ModifyQpsMode API asynchronously
func (client *Client) ModifyQpsModeWithCallback(request *ModifyQpsModeRequest, callback func(response *ModifyQpsModeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyQpsModeResponse
		var err error
		defer close(result)
		response, err = client.ModifyQpsMode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyQpsModeRequest is the request struct for api ModifyQpsMode
type ModifyQpsModeRequest struct {
	*requests.RpcRequest
	Mode       string `position:"Query" name:"Mode"`
	InstanceId string `position:"Query" name:"InstanceId"`
	SourceIp   string `position:"Query" name:"SourceIp"`
}

// ModifyQpsModeResponse is the response struct for api ModifyQpsMode
type ModifyQpsModeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyQpsModeRequest creates a request to invoke ModifyQpsMode API
func CreateModifyQpsModeRequest() (request *ModifyQpsModeRequest) {
	request = &ModifyQpsModeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "ModifyQpsMode", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyQpsModeResponse creates a response to parse from ModifyQpsMode response
func CreateModifyQpsModeResponse() (response *ModifyQpsModeResponse) {
	response = &ModifyQpsModeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
