package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeWebReportTopIp invokes the ddoscoo.DescribeWebReportTopIp API synchronously
func (client *Client) DescribeWebReportTopIp(request *DescribeWebReportTopIpRequest) (response *DescribeWebReportTopIpResponse, err error) {
	response = CreateDescribeWebReportTopIpResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeWebReportTopIpWithChan invokes the ddoscoo.DescribeWebReportTopIp API asynchronously
func (client *Client) DescribeWebReportTopIpWithChan(request *DescribeWebReportTopIpRequest) (<-chan *DescribeWebReportTopIpResponse, <-chan error) {
	responseChan := make(chan *DescribeWebReportTopIpResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeWebReportTopIp(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeWebReportTopIpWithCallback invokes the ddoscoo.DescribeWebReportTopIp API asynchronously
func (client *Client) DescribeWebReportTopIpWithCallback(request *DescribeWebReportTopIpRequest, callback func(response *DescribeWebReportTopIpResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeWebReportTopIpResponse
		var err error
		defer close(result)
		response, err = client.DescribeWebReportTopIp(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeWebReportTopIpRequest is the request struct for api DescribeWebReportTopIp
type DescribeWebReportTopIpRequest struct {
	*requests.RpcRequest
	StartTime requests.Integer `position:"Query" name:"StartTime"`
	SourceIp  string           `position:"Query" name:"SourceIp"`
	Top       requests.Integer `position:"Query" name:"Top"`
	QueryType string           `position:"Query" name:"QueryType"`
	EndTime   requests.Integer `position:"Query" name:"EndTime"`
	Domain    string           `position:"Query" name:"Domain"`
	Interval  requests.Integer `position:"Query" name:"Interval"`
}

// DescribeWebReportTopIpResponse is the response struct for api DescribeWebReportTopIp
type DescribeWebReportTopIpResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	DataList  []DataItem `json:"DataList" xml:"DataList"`
}

// CreateDescribeWebReportTopIpRequest creates a request to invoke DescribeWebReportTopIp API
func CreateDescribeWebReportTopIpRequest() (request *DescribeWebReportTopIpRequest) {
	request = &DescribeWebReportTopIpRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeWebReportTopIp", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeWebReportTopIpResponse creates a response to parse from DescribeWebReportTopIp response
func CreateDescribeWebReportTopIpResponse() (response *DescribeWebReportTopIpResponse) {
	response = &DescribeWebReportTopIpResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
