package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PutDcdnKvNamespace invokes the dcdn.PutDcdnKvNamespace API synchronously
func (client *Client) PutDcdnKvNamespace(request *PutDcdnKvNamespaceRequest) (response *PutDcdnKvNamespaceResponse, err error) {
	response = CreatePutDcdnKvNamespaceResponse()
	err = client.DoAction(request, response)
	return
}

// PutDcdnKvNamespaceWithChan invokes the dcdn.PutDcdnKvNamespace API asynchronously
func (client *Client) PutDcdnKvNamespaceWithChan(request *PutDcdnKvNamespaceRequest) (<-chan *PutDcdnKvNamespaceResponse, <-chan error) {
	responseChan := make(chan *PutDcdnKvNamespaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PutDcdnKvNamespace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PutDcdnKvNamespaceWithCallback invokes the dcdn.PutDcdnKvNamespace API asynchronously
func (client *Client) PutDcdnKvNamespaceWithCallback(request *PutDcdnKvNamespaceRequest, callback func(response *PutDcdnKvNamespaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PutDcdnKvNamespaceResponse
		var err error
		defer close(result)
		response, err = client.PutDcdnKvNamespace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PutDcdnKvNamespaceRequest is the request struct for api PutDcdnKvNamespace
type PutDcdnKvNamespaceRequest struct {
	*requests.RpcRequest
	Namespace   string `position:"Body" name:"Namespace"`
	Description string `position:"Body" name:"Description"`
}

// PutDcdnKvNamespaceResponse is the response struct for api PutDcdnKvNamespace
type PutDcdnKvNamespaceResponse struct {
	*responses.BaseResponse
	Status      string `json:"Status" xml:"Status"`
	Namespace   string `json:"Namespace" xml:"Namespace"`
	NamespaceId string `json:"NamespaceId" xml:"NamespaceId"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
	Description string `json:"Description" xml:"Description"`
}

// CreatePutDcdnKvNamespaceRequest creates a request to invoke PutDcdnKvNamespace API
func CreatePutDcdnKvNamespaceRequest() (request *PutDcdnKvNamespaceRequest) {
	request = &PutDcdnKvNamespaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "PutDcdnKvNamespace", "", "")
	request.Method = requests.POST
	return
}

// CreatePutDcdnKvNamespaceResponse creates a response to parse from PutDcdnKvNamespace response
func CreatePutDcdnKvNamespaceResponse() (response *PutDcdnKvNamespaceResponse) {
	response = &PutDcdnKvNamespaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
