package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnKvAccount invokes the dcdn.DescribeDcdnKvAccount API synchronously
func (client *Client) DescribeDcdnKvAccount(request *DescribeDcdnKvAccountRequest) (response *DescribeDcdnKvAccountResponse, err error) {
	response = CreateDescribeDcdnKvAccountResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnKvAccountWithChan invokes the dcdn.DescribeDcdnKvAccount API asynchronously
func (client *Client) DescribeDcdnKvAccountWithChan(request *DescribeDcdnKvAccountRequest) (<-chan *DescribeDcdnKvAccountResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnKvAccountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnKvAccount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnKvAccountWithCallback invokes the dcdn.DescribeDcdnKvAccount API asynchronously
func (client *Client) DescribeDcdnKvAccountWithCallback(request *DescribeDcdnKvAccountRequest, callback func(response *DescribeDcdnKvAccountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnKvAccountResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnKvAccount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnKvAccountRequest is the request struct for api DescribeDcdnKvAccount
type DescribeDcdnKvAccountRequest struct {
	*requests.RpcRequest
}

// DescribeDcdnKvAccountResponse is the response struct for api DescribeDcdnKvAccount
type DescribeDcdnKvAccountResponse struct {
	*responses.BaseResponse
	Status             string       `json:"Status" xml:"Status"`
	RequestId          string       `json:"RequestId" xml:"RequestId"`
	NamespaceUsed      int          `json:"NamespaceUsed" xml:"NamespaceUsed"`
	NamespaceQuota     int          `json:"NamespaceQuota" xml:"NamespaceQuota"`
	CapacityString     string       `json:"CapacityString" xml:"CapacityString"`
	CapacityUsedString string       `json:"CapacityUsedString" xml:"CapacityUsedString"`
	NamespaceList      []Namespaces `json:"NamespaceList" xml:"NamespaceList"`
}

// CreateDescribeDcdnKvAccountRequest creates a request to invoke DescribeDcdnKvAccount API
func CreateDescribeDcdnKvAccountRequest() (request *DescribeDcdnKvAccountRequest) {
	request = &DescribeDcdnKvAccountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnKvAccount", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeDcdnKvAccountResponse creates a response to parse from DescribeDcdnKvAccount response
func CreateDescribeDcdnKvAccountResponse() (response *DescribeDcdnKvAccountResponse) {
	response = &DescribeDcdnKvAccountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
