package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnHttpsDomainList invokes the dcdn.DescribeDcdnHttpsDomainList API synchronously
func (client *Client) DescribeDcdnHttpsDomainList(request *DescribeDcdnHttpsDomainListRequest) (response *DescribeDcdnHttpsDomainListResponse, err error) {
	response = CreateDescribeDcdnHttpsDomainListResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnHttpsDomainListWithChan invokes the dcdn.DescribeDcdnHttpsDomainList API asynchronously
func (client *Client) DescribeDcdnHttpsDomainListWithChan(request *DescribeDcdnHttpsDomainListRequest) (<-chan *DescribeDcdnHttpsDomainListResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnHttpsDomainListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnHttpsDomainList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnHttpsDomainListWithCallback invokes the dcdn.DescribeDcdnHttpsDomainList API asynchronously
func (client *Client) DescribeDcdnHttpsDomainListWithCallback(request *DescribeDcdnHttpsDomainListRequest, callback func(response *DescribeDcdnHttpsDomainListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnHttpsDomainListResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnHttpsDomainList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnHttpsDomainListRequest is the request struct for api DescribeDcdnHttpsDomainList
type DescribeDcdnHttpsDomainListRequest struct {
	*requests.RpcRequest
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
	Keyword    string           `position:"Query" name:"Keyword"`
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
}

// DescribeDcdnHttpsDomainListResponse is the response struct for api DescribeDcdnHttpsDomainList
type DescribeDcdnHttpsDomainListResponse struct {
	*responses.BaseResponse
	TotalCount int                                    `json:"TotalCount" xml:"TotalCount"`
	RequestId  string                                 `json:"RequestId" xml:"RequestId"`
	CertInfos  CertInfosInDescribeDcdnHttpsDomainList `json:"CertInfos" xml:"CertInfos"`
}

// CreateDescribeDcdnHttpsDomainListRequest creates a request to invoke DescribeDcdnHttpsDomainList API
func CreateDescribeDcdnHttpsDomainListRequest() (request *DescribeDcdnHttpsDomainListRequest) {
	request = &DescribeDcdnHttpsDomainListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnHttpsDomainList", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnHttpsDomainListResponse creates a response to parse from DescribeDcdnHttpsDomainList response
func CreateDescribeDcdnHttpsDomainListResponse() (response *DescribeDcdnHttpsDomainListResponse) {
	response = &DescribeDcdnHttpsDomainListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
