package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnFullDomainsBlockIPHistory invokes the dcdn.DescribeDcdnFullDomainsBlockIPHistory API synchronously
func (client *Client) DescribeDcdnFullDomainsBlockIPHistory(request *DescribeDcdnFullDomainsBlockIPHistoryRequest) (response *DescribeDcdnFullDomainsBlockIPHistoryResponse, err error) {
	response = CreateDescribeDcdnFullDomainsBlockIPHistoryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnFullDomainsBlockIPHistoryWithChan invokes the dcdn.DescribeDcdnFullDomainsBlockIPHistory API asynchronously
func (client *Client) DescribeDcdnFullDomainsBlockIPHistoryWithChan(request *DescribeDcdnFullDomainsBlockIPHistoryRequest) (<-chan *DescribeDcdnFullDomainsBlockIPHistoryResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnFullDomainsBlockIPHistoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnFullDomainsBlockIPHistory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnFullDomainsBlockIPHistoryWithCallback invokes the dcdn.DescribeDcdnFullDomainsBlockIPHistory API asynchronously
func (client *Client) DescribeDcdnFullDomainsBlockIPHistoryWithCallback(request *DescribeDcdnFullDomainsBlockIPHistoryRequest, callback func(response *DescribeDcdnFullDomainsBlockIPHistoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnFullDomainsBlockIPHistoryResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnFullDomainsBlockIPHistory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnFullDomainsBlockIPHistoryRequest is the request struct for api DescribeDcdnFullDomainsBlockIPHistory
type DescribeDcdnFullDomainsBlockIPHistoryRequest struct {
	*requests.RpcRequest
	EndTime   string `position:"Body" name:"EndTime"`
	StartTime string `position:"Body" name:"StartTime"`
	IPList    string `position:"Body" name:"IPList"`
}

// DescribeDcdnFullDomainsBlockIPHistoryResponse is the response struct for api DescribeDcdnFullDomainsBlockIPHistory
type DescribeDcdnFullDomainsBlockIPHistoryResponse struct {
	*responses.BaseResponse
	RequestId   string           `json:"RequestId" xml:"RequestId"`
	Code        int              `json:"Code" xml:"Code"`
	Description string           `json:"Description" xml:"Description"`
	IPBlockInfo []IPBlockHistory `json:"IPBlockInfo" xml:"IPBlockInfo"`
}

// CreateDescribeDcdnFullDomainsBlockIPHistoryRequest creates a request to invoke DescribeDcdnFullDomainsBlockIPHistory API
func CreateDescribeDcdnFullDomainsBlockIPHistoryRequest() (request *DescribeDcdnFullDomainsBlockIPHistoryRequest) {
	request = &DescribeDcdnFullDomainsBlockIPHistoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnFullDomainsBlockIPHistory", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnFullDomainsBlockIPHistoryResponse creates a response to parse from DescribeDcdnFullDomainsBlockIPHistory response
func CreateDescribeDcdnFullDomainsBlockIPHistoryResponse() (response *DescribeDcdnFullDomainsBlockIPHistoryResponse) {
	response = &DescribeDcdnFullDomainsBlockIPHistoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
