package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateWorkbenchEventResult invokes the dataworks_public.UpdateWorkbenchEventResult API synchronously
func (client *Client) UpdateWorkbenchEventResult(request *UpdateWorkbenchEventResultRequest) (response *UpdateWorkbenchEventResultResponse, err error) {
	response = CreateUpdateWorkbenchEventResultResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateWorkbenchEventResultWithChan invokes the dataworks_public.UpdateWorkbenchEventResult API asynchronously
func (client *Client) UpdateWorkbenchEventResultWithChan(request *UpdateWorkbenchEventResultRequest) (<-chan *UpdateWorkbenchEventResultResponse, <-chan error) {
	responseChan := make(chan *UpdateWorkbenchEventResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateWorkbenchEventResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateWorkbenchEventResultWithCallback invokes the dataworks_public.UpdateWorkbenchEventResult API asynchronously
func (client *Client) UpdateWorkbenchEventResultWithCallback(request *UpdateWorkbenchEventResultRequest, callback func(response *UpdateWorkbenchEventResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateWorkbenchEventResultResponse
		var err error
		defer close(result)
		response, err = client.UpdateWorkbenchEventResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateWorkbenchEventResultRequest is the request struct for api UpdateWorkbenchEventResult
type UpdateWorkbenchEventResultRequest struct {
	*requests.RpcRequest
	CheckResult    string `position:"Query" name:"CheckResult"`
	MessageId      string `position:"Query" name:"MessageId"`
	CheckResultTip string `position:"Query" name:"CheckResultTip"`
	ExtensionCode  string `position:"Query" name:"ExtensionCode"`
}

// UpdateWorkbenchEventResultResponse is the response struct for api UpdateWorkbenchEventResult
type UpdateWorkbenchEventResultResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUpdateWorkbenchEventResultRequest creates a request to invoke UpdateWorkbenchEventResult API
func CreateUpdateWorkbenchEventResultRequest() (request *UpdateWorkbenchEventResultRequest) {
	request = &UpdateWorkbenchEventResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "UpdateWorkbenchEventResult", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateWorkbenchEventResultResponse creates a response to parse from UpdateWorkbenchEventResult response
func CreateUpdateWorkbenchEventResultResponse() (response *UpdateWorkbenchEventResultResponse) {
	response = &UpdateWorkbenchEventResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
