package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTableTheme invokes the dataworks_public.ListTableTheme API synchronously
func (client *Client) ListTableTheme(request *ListTableThemeRequest) (response *ListTableThemeResponse, err error) {
	response = CreateListTableThemeResponse()
	err = client.DoAction(request, response)
	return
}

// ListTableThemeWithChan invokes the dataworks_public.ListTableTheme API asynchronously
func (client *Client) ListTableThemeWithChan(request *ListTableThemeRequest) (<-chan *ListTableThemeResponse, <-chan error) {
	responseChan := make(chan *ListTableThemeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTableTheme(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTableThemeWithCallback invokes the dataworks_public.ListTableTheme API asynchronously
func (client *Client) ListTableThemeWithCallback(request *ListTableThemeRequest, callback func(response *ListTableThemeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTableThemeResponse
		var err error
		defer close(result)
		response, err = client.ListTableTheme(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTableThemeRequest is the request struct for api ListTableTheme
type ListTableThemeRequest struct {
	*requests.RpcRequest
	PageNum   requests.Integer `position:"Query" name:"PageNum"`
	ParentId  requests.Integer `position:"Query" name:"ParentId"`
	PageSize  requests.Integer `position:"Query" name:"PageSize"`
	ProjectId requests.Integer `position:"Query" name:"ProjectId"`
}

// ListTableThemeResponse is the response struct for api ListTableTheme
type ListTableThemeResponse struct {
	*responses.BaseResponse
	HttpStatusCode int                  `json:"HttpStatusCode" xml:"HttpStatusCode"`
	ErrorMessage   string               `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId      string               `json:"RequestId" xml:"RequestId"`
	Success        bool                 `json:"Success" xml:"Success"`
	ErrorCode      string               `json:"ErrorCode" xml:"ErrorCode"`
	Data           DataInListTableTheme `json:"Data" xml:"Data"`
}

// CreateListTableThemeRequest creates a request to invoke ListTableTheme API
func CreateListTableThemeRequest() (request *ListTableThemeRequest) {
	request = &ListTableThemeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListTableTheme", "", "")
	request.Method = requests.GET
	return
}

// CreateListTableThemeResponse creates a response to parse from ListTableTheme response
func CreateListTableThemeResponse() (response *ListTableThemeResponse) {
	response = &ListTableThemeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
