package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DsgSceneQuerySceneListByName invokes the dataworks_public.DsgSceneQuerySceneListByName API synchronously
func (client *Client) DsgSceneQuerySceneListByName(request *DsgSceneQuerySceneListByNameRequest) (response *DsgSceneQuerySceneListByNameResponse, err error) {
	response = CreateDsgSceneQuerySceneListByNameResponse()
	err = client.DoAction(request, response)
	return
}

// DsgSceneQuerySceneListByNameWithChan invokes the dataworks_public.DsgSceneQuerySceneListByName API asynchronously
func (client *Client) DsgSceneQuerySceneListByNameWithChan(request *DsgSceneQuerySceneListByNameRequest) (<-chan *DsgSceneQuerySceneListByNameResponse, <-chan error) {
	responseChan := make(chan *DsgSceneQuerySceneListByNameResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DsgSceneQuerySceneListByName(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DsgSceneQuerySceneListByNameWithCallback invokes the dataworks_public.DsgSceneQuerySceneListByName API asynchronously
func (client *Client) DsgSceneQuerySceneListByNameWithCallback(request *DsgSceneQuerySceneListByNameRequest, callback func(response *DsgSceneQuerySceneListByNameResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DsgSceneQuerySceneListByNameResponse
		var err error
		defer close(result)
		response, err = client.DsgSceneQuerySceneListByName(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DsgSceneQuerySceneListByNameRequest is the request struct for api DsgSceneQuerySceneListByName
type DsgSceneQuerySceneListByNameRequest struct {
	*requests.RpcRequest
	SceneName string `position:"Query" name:"SceneName"`
}

// DsgSceneQuerySceneListByNameResponse is the response struct for api DsgSceneQuerySceneListByName
type DsgSceneQuerySceneListByNameResponse struct {
	*responses.BaseResponse
	Success        bool    `json:"Success" xml:"Success"`
	ErrorCode      string  `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string  `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int     `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string  `json:"RequestId" xml:"RequestId"`
	Data           []Datas `json:"Data" xml:"Data"`
}

// CreateDsgSceneQuerySceneListByNameRequest creates a request to invoke DsgSceneQuerySceneListByName API
func CreateDsgSceneQuerySceneListByNameRequest() (request *DsgSceneQuerySceneListByNameRequest) {
	request = &DsgSceneQuerySceneListByNameRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DsgSceneQuerySceneListByName", "", "")
	request.Method = requests.GET
	return
}

// CreateDsgSceneQuerySceneListByNameResponse creates a response to parse from DsgSceneQuerySceneListByName response
func CreateDsgSceneQuerySceneListByNameResponse() (response *DsgSceneQuerySceneListByNameResponse) {
	response = &DsgSceneQuerySceneListByNameResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
