package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteRecognizeRule invokes the dataworks_public.DeleteRecognizeRule API synchronously
func (client *Client) DeleteRecognizeRule(request *DeleteRecognizeRuleRequest) (response *DeleteRecognizeRuleResponse, err error) {
	response = CreateDeleteRecognizeRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteRecognizeRuleWithChan invokes the dataworks_public.DeleteRecognizeRule API asynchronously
func (client *Client) DeleteRecognizeRuleWithChan(request *DeleteRecognizeRuleRequest) (<-chan *DeleteRecognizeRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteRecognizeRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteRecognizeRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteRecognizeRuleWithCallback invokes the dataworks_public.DeleteRecognizeRule API asynchronously
func (client *Client) DeleteRecognizeRuleWithCallback(request *DeleteRecognizeRuleRequest, callback func(response *DeleteRecognizeRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteRecognizeRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteRecognizeRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteRecognizeRuleRequest is the request struct for api DeleteRecognizeRule
type DeleteRecognizeRuleRequest struct {
	*requests.RpcRequest
	SensitiveId string `position:"Body" name:"SensitiveId"`
	TenantId    string `position:"Body" name:"TenantId"`
}

// DeleteRecognizeRuleResponse is the response struct for api DeleteRecognizeRule
type DeleteRecognizeRuleResponse struct {
	*responses.BaseResponse
}

// CreateDeleteRecognizeRuleRequest creates a request to invoke DeleteRecognizeRule API
func CreateDeleteRecognizeRuleRequest() (request *DeleteRecognizeRuleRequest) {
	request = &DeleteRecognizeRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DeleteRecognizeRule", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteRecognizeRuleResponse creates a response to parse from DeleteRecognizeRule response
func CreateDeleteRecognizeRuleResponse() (response *DeleteRecognizeRuleResponse) {
	response = &DeleteRecognizeRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
