package cusanalytic_sc_online

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAnalyzePlaceData invokes the cusanalytic_sc_online.GetAnalyzePlaceData API synchronously
// api document: https://help.aliyun.com/api/cusanalytic_sc_online/getanalyzeplacedata.html
func (client *Client) GetAnalyzePlaceData(request *GetAnalyzePlaceDataRequest) (response *GetAnalyzePlaceDataResponse, err error) {
	response = CreateGetAnalyzePlaceDataResponse()
	err = client.DoAction(request, response)
	return
}

// GetAnalyzePlaceDataWithChan invokes the cusanalytic_sc_online.GetAnalyzePlaceData API asynchronously
// api document: https://help.aliyun.com/api/cusanalytic_sc_online/getanalyzeplacedata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetAnalyzePlaceDataWithChan(request *GetAnalyzePlaceDataRequest) (<-chan *GetAnalyzePlaceDataResponse, <-chan error) {
	responseChan := make(chan *GetAnalyzePlaceDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAnalyzePlaceData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAnalyzePlaceDataWithCallback invokes the cusanalytic_sc_online.GetAnalyzePlaceData API asynchronously
// api document: https://help.aliyun.com/api/cusanalytic_sc_online/getanalyzeplacedata.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetAnalyzePlaceDataWithCallback(request *GetAnalyzePlaceDataRequest, callback func(response *GetAnalyzePlaceDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAnalyzePlaceDataResponse
		var err error
		defer close(result)
		response, err = client.GetAnalyzePlaceData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAnalyzePlaceDataRequest is the request struct for api GetAnalyzePlaceData
type GetAnalyzePlaceDataRequest struct {
	*requests.RpcRequest
	EndUVCount        requests.Integer `position:"Body" name:"EndUVCount"`
	ParentAmount      requests.Integer `position:"Body" name:"ParentAmount"`
	StartDate         string           `position:"Body" name:"StartDate"`
	StartUVCount      requests.Integer `position:"Body" name:"StartUVCount"`
	StoreId           requests.Integer `position:"Body" name:"StoreId"`
	EndDate           string           `position:"Body" name:"EndDate"`
	LocationId        requests.Integer `position:"Body" name:"LocationId"`
	ParentLocationIds string           `position:"Body" name:"ParentLocationIds"`
}

// GetAnalyzePlaceDataResponse is the response struct for api GetAnalyzePlaceData
type GetAnalyzePlaceDataResponse struct {
	*responses.BaseResponse
	Count             int64             `json:"Count" xml:"Count"`
	StoreId           int64             `json:"StoreId" xml:"StoreId"`
	Percent           float64           `json:"Percent" xml:"Percent"`
	LocationName      string            `json:"LocationName" xml:"LocationName"`
	ParentLocationIds string            `json:"ParentLocationIds" xml:"ParentLocationIds"`
	LocationId        int64             `json:"LocationId" xml:"LocationId"`
	AnalyzePlaceItems AnalyzePlaceItems `json:"AnalyzePlaceItems" xml:"AnalyzePlaceItems"`
}

// CreateGetAnalyzePlaceDataRequest creates a request to invoke GetAnalyzePlaceData API
func CreateGetAnalyzePlaceDataRequest() (request *GetAnalyzePlaceDataRequest) {
	request = &GetAnalyzePlaceDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cusanalytic_sc_online", "2019-05-24", "GetAnalyzePlaceData", "", "")
	return
}

// CreateGetAnalyzePlaceDataResponse creates a response to parse from GetAnalyzePlaceData response
func CreateGetAnalyzePlaceDataResponse() (response *GetAnalyzePlaceDataResponse) {
	response = &GetAnalyzePlaceDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
