package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSoftwareForUserDevice invokes the csas.ListSoftwareForUserDevice API synchronously
func (client *Client) ListSoftwareForUserDevice(request *ListSoftwareForUserDeviceRequest) (response *ListSoftwareForUserDeviceResponse, err error) {
	response = CreateListSoftwareForUserDeviceResponse()
	err = client.DoAction(request, response)
	return
}

// ListSoftwareForUserDeviceWithChan invokes the csas.ListSoftwareForUserDevice API asynchronously
func (client *Client) ListSoftwareForUserDeviceWithChan(request *ListSoftwareForUserDeviceRequest) (<-chan *ListSoftwareForUserDeviceResponse, <-chan error) {
	responseChan := make(chan *ListSoftwareForUserDeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSoftwareForUserDevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSoftwareForUserDeviceWithCallback invokes the csas.ListSoftwareForUserDevice API asynchronously
func (client *Client) ListSoftwareForUserDeviceWithCallback(request *ListSoftwareForUserDeviceRequest, callback func(response *ListSoftwareForUserDeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSoftwareForUserDeviceResponse
		var err error
		defer close(result)
		response, err = client.ListSoftwareForUserDevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSoftwareForUserDeviceRequest is the request struct for api ListSoftwareForUserDevice
type ListSoftwareForUserDeviceRequest struct {
	*requests.RpcRequest
	DeviceTag   string           `position:"Query" name:"DeviceTag"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
}

// ListSoftwareForUserDeviceResponse is the response struct for api ListSoftwareForUserDevice
type ListSoftwareForUserDeviceResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	TotalNum  int64      `json:"TotalNum" xml:"TotalNum"`
	Software  []DataList `json:"Software" xml:"Software"`
}

// CreateListSoftwareForUserDeviceRequest creates a request to invoke ListSoftwareForUserDevice API
func CreateListSoftwareForUserDeviceRequest() (request *ListSoftwareForUserDeviceRequest) {
	request = &ListSoftwareForUserDeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "ListSoftwareForUserDevice", "", "")
	request.Method = requests.GET
	return
}

// CreateListSoftwareForUserDeviceResponse creates a response to parse from ListSoftwareForUserDevice response
func CreateListSoftwareForUserDeviceResponse() (response *ListSoftwareForUserDeviceResponse) {
	response = &ListSoftwareForUserDeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
