package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPolicesForPrivateAccessApplication invokes the csas.ListPolicesForPrivateAccessApplication API synchronously
func (client *Client) ListPolicesForPrivateAccessApplication(request *ListPolicesForPrivateAccessApplicationRequest) (response *ListPolicesForPrivateAccessApplicationResponse, err error) {
	response = CreateListPolicesForPrivateAccessApplicationResponse()
	err = client.DoAction(request, response)
	return
}

// ListPolicesForPrivateAccessApplicationWithChan invokes the csas.ListPolicesForPrivateAccessApplication API asynchronously
func (client *Client) ListPolicesForPrivateAccessApplicationWithChan(request *ListPolicesForPrivateAccessApplicationRequest) (<-chan *ListPolicesForPrivateAccessApplicationResponse, <-chan error) {
	responseChan := make(chan *ListPolicesForPrivateAccessApplicationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPolicesForPrivateAccessApplication(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPolicesForPrivateAccessApplicationWithCallback invokes the csas.ListPolicesForPrivateAccessApplication API asynchronously
func (client *Client) ListPolicesForPrivateAccessApplicationWithCallback(request *ListPolicesForPrivateAccessApplicationRequest, callback func(response *ListPolicesForPrivateAccessApplicationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPolicesForPrivateAccessApplicationResponse
		var err error
		defer close(result)
		response, err = client.ListPolicesForPrivateAccessApplication(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPolicesForPrivateAccessApplicationRequest is the request struct for api ListPolicesForPrivateAccessApplication
type ListPolicesForPrivateAccessApplicationRequest struct {
	*requests.RpcRequest
	ApplicationIds *[]string `position:"Query" name:"ApplicationIds"  type:"Repeated"`
	SourceIp       string    `position:"Query" name:"SourceIp"`
}

// ListPolicesForPrivateAccessApplicationResponse is the response struct for api ListPolicesForPrivateAccessApplication
type ListPolicesForPrivateAccessApplicationResponse struct {
	*responses.BaseResponse
	RequestId    string        `json:"RequestId" xml:"RequestId"`
	Applications []Application `json:"Applications" xml:"Applications"`
}

// CreateListPolicesForPrivateAccessApplicationRequest creates a request to invoke ListPolicesForPrivateAccessApplication API
func CreateListPolicesForPrivateAccessApplicationRequest() (request *ListPolicesForPrivateAccessApplicationRequest) {
	request = &ListPolicesForPrivateAccessApplicationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "ListPolicesForPrivateAccessApplication", "", "")
	request.Method = requests.GET
	return
}

// CreateListPolicesForPrivateAccessApplicationResponse creates a response to parse from ListPolicesForPrivateAccessApplication response
func CreateListPolicesForPrivateAccessApplicationResponse() (response *ListPolicesForPrivateAccessApplicationResponse) {
	response = &ListPolicesForPrivateAccessApplicationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
