package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDynamicRoutes invokes the csas.ListDynamicRoutes API synchronously
func (client *Client) ListDynamicRoutes(request *ListDynamicRoutesRequest) (response *ListDynamicRoutesResponse, err error) {
	response = CreateListDynamicRoutesResponse()
	err = client.DoAction(request, response)
	return
}

// ListDynamicRoutesWithChan invokes the csas.ListDynamicRoutes API asynchronously
func (client *Client) ListDynamicRoutesWithChan(request *ListDynamicRoutesRequest) (<-chan *ListDynamicRoutesResponse, <-chan error) {
	responseChan := make(chan *ListDynamicRoutesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDynamicRoutes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDynamicRoutesWithCallback invokes the csas.ListDynamicRoutes API asynchronously
func (client *Client) ListDynamicRoutesWithCallback(request *ListDynamicRoutesRequest, callback func(response *ListDynamicRoutesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDynamicRoutesResponse
		var err error
		defer close(result)
		response, err = client.ListDynamicRoutes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDynamicRoutesRequest is the request struct for api ListDynamicRoutes
type ListDynamicRoutesRequest struct {
	*requests.RpcRequest
	SourceIp        string           `position:"Query" name:"SourceIp"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	ApplicationId   string           `position:"Query" name:"ApplicationId"`
	DynamicRouteIds *[]string        `position:"Query" name:"DynamicRouteIds"  type:"Repeated"`
	TagId           string           `position:"Query" name:"TagId"`
	CurrentPage     requests.Integer `position:"Query" name:"CurrentPage"`
	RegionIds       *[]string        `position:"Query" name:"RegionIds"  type:"Repeated"`
	NextHop         string           `position:"Query" name:"NextHop"`
	Name            string           `position:"Query" name:"Name"`
	Status          string           `position:"Query" name:"Status"`
}

// ListDynamicRoutesResponse is the response struct for api ListDynamicRoutes
type ListDynamicRoutesResponse struct {
	*responses.BaseResponse
	RequestId     string         `json:"RequestId" xml:"RequestId"`
	TotalNum      int            `json:"TotalNum" xml:"TotalNum"`
	DynamicRoutes []DynamicRoute `json:"DynamicRoutes" xml:"DynamicRoutes"`
}

// CreateListDynamicRoutesRequest creates a request to invoke ListDynamicRoutes API
func CreateListDynamicRoutesRequest() (request *ListDynamicRoutesRequest) {
	request = &ListDynamicRoutesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "ListDynamicRoutes", "", "")
	request.Method = requests.GET
	return
}

// CreateListDynamicRoutesResponse creates a response to parse from ListDynamicRoutes response
func CreateListDynamicRoutesResponse() (response *ListDynamicRoutesResponse) {
	response = &ListDynamicRoutesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
