package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListApprovalProcessesForApprovalSchemas invokes the csas.ListApprovalProcessesForApprovalSchemas API synchronously
func (client *Client) ListApprovalProcessesForApprovalSchemas(request *ListApprovalProcessesForApprovalSchemasRequest) (response *ListApprovalProcessesForApprovalSchemasResponse, err error) {
	response = CreateListApprovalProcessesForApprovalSchemasResponse()
	err = client.DoAction(request, response)
	return
}

// ListApprovalProcessesForApprovalSchemasWithChan invokes the csas.ListApprovalProcessesForApprovalSchemas API asynchronously
func (client *Client) ListApprovalProcessesForApprovalSchemasWithChan(request *ListApprovalProcessesForApprovalSchemasRequest) (<-chan *ListApprovalProcessesForApprovalSchemasResponse, <-chan error) {
	responseChan := make(chan *ListApprovalProcessesForApprovalSchemasResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListApprovalProcessesForApprovalSchemas(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListApprovalProcessesForApprovalSchemasWithCallback invokes the csas.ListApprovalProcessesForApprovalSchemas API asynchronously
func (client *Client) ListApprovalProcessesForApprovalSchemasWithCallback(request *ListApprovalProcessesForApprovalSchemasRequest, callback func(response *ListApprovalProcessesForApprovalSchemasResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListApprovalProcessesForApprovalSchemasResponse
		var err error
		defer close(result)
		response, err = client.ListApprovalProcessesForApprovalSchemas(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListApprovalProcessesForApprovalSchemasRequest is the request struct for api ListApprovalProcessesForApprovalSchemas
type ListApprovalProcessesForApprovalSchemasRequest struct {
	*requests.RpcRequest
	SourceIp  string    `position:"Query" name:"SourceIp"`
	SchemaIds *[]string `position:"Query" name:"SchemaIds"  type:"Repeated"`
}

// ListApprovalProcessesForApprovalSchemasResponse is the response struct for api ListApprovalProcessesForApprovalSchemas
type ListApprovalProcessesForApprovalSchemasResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Schemas   []Data `json:"Schemas" xml:"Schemas"`
}

// CreateListApprovalProcessesForApprovalSchemasRequest creates a request to invoke ListApprovalProcessesForApprovalSchemas API
func CreateListApprovalProcessesForApprovalSchemasRequest() (request *ListApprovalProcessesForApprovalSchemasRequest) {
	request = &ListApprovalProcessesForApprovalSchemasRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "ListApprovalProcessesForApprovalSchemas", "", "")
	request.Method = requests.GET
	return
}

// CreateListApprovalProcessesForApprovalSchemasResponse creates a response to parse from ListApprovalProcessesForApprovalSchemas response
func CreateListApprovalProcessesForApprovalSchemasResponse() (response *ListApprovalProcessesForApprovalSchemasResponse) {
	response = &ListApprovalProcessesForApprovalSchemasResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
