package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUserGroup invokes the csas.GetUserGroup API synchronously
func (client *Client) GetUserGroup(request *GetUserGroupRequest) (response *GetUserGroupResponse, err error) {
	response = CreateGetUserGroupResponse()
	err = client.DoAction(request, response)
	return
}

// GetUserGroupWithChan invokes the csas.GetUserGroup API asynchronously
func (client *Client) GetUserGroupWithChan(request *GetUserGroupRequest) (<-chan *GetUserGroupResponse, <-chan error) {
	responseChan := make(chan *GetUserGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUserGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUserGroupWithCallback invokes the csas.GetUserGroup API asynchronously
func (client *Client) GetUserGroupWithCallback(request *GetUserGroupRequest, callback func(response *GetUserGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUserGroupResponse
		var err error
		defer close(result)
		response, err = client.GetUserGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUserGroupRequest is the request struct for api GetUserGroup
type GetUserGroupRequest struct {
	*requests.RpcRequest
	UserGroupId string `position:"Query" name:"UserGroupId"`
	SourceIp    string `position:"Query" name:"SourceIp"`
}

// GetUserGroupResponse is the response struct for api GetUserGroup
type GetUserGroupResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	UserGroup UserGroup `json:"UserGroup" xml:"UserGroup"`
}

// CreateGetUserGroupRequest creates a request to invoke GetUserGroup API
func CreateGetUserGroupRequest() (request *GetUserGroupRequest) {
	request = &GetUserGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "GetUserGroup", "", "")
	request.Method = requests.GET
	return
}

// CreateGetUserGroupResponse creates a response to parse from GetUserGroup response
func CreateGetUserGroupResponse() (response *GetUserGroupResponse) {
	response = &GetUserGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
