package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateWmExtractTask invokes the csas.CreateWmExtractTask API synchronously
func (client *Client) CreateWmExtractTask(request *CreateWmExtractTaskRequest) (response *CreateWmExtractTaskResponse, err error) {
	response = CreateCreateWmExtractTaskResponse()
	err = client.DoAction(request, response)
	return
}

// CreateWmExtractTaskWithChan invokes the csas.CreateWmExtractTask API asynchronously
func (client *Client) CreateWmExtractTaskWithChan(request *CreateWmExtractTaskRequest) (<-chan *CreateWmExtractTaskResponse, <-chan error) {
	responseChan := make(chan *CreateWmExtractTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateWmExtractTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateWmExtractTaskWithCallback invokes the csas.CreateWmExtractTask API asynchronously
func (client *Client) CreateWmExtractTaskWithCallback(request *CreateWmExtractTaskRequest, callback func(response *CreateWmExtractTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateWmExtractTaskResponse
		var err error
		defer close(result)
		response, err = client.CreateWmExtractTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateWmExtractTaskRequest is the request struct for api CreateWmExtractTask
type CreateWmExtractTaskRequest struct {
	*requests.RpcRequest
	VideoIsLong       requests.Boolean              `position:"Body" name:"VideoIsLong"`
	DocumentIsCapture requests.Boolean              `position:"Body" name:"DocumentIsCapture"`
	VideoSpeed        string                        `position:"Body" name:"VideoSpeed"`
	ApiType           string                        `position:"Body" name:"ApiType"`
	SourceIp          string                        `position:"Query" name:"SourceIp"`
	WmType            string                        `position:"Body" name:"WmType"`
	ImageDetectLevel  requests.Integer              `position:"Body" name:"ImageDetectLevel"`
	CsvControl        CreateWmExtractTaskCsvControl `position:"Query" name:"CsvControl"  type:"Struct"`
	Filename          string                        `position:"Body" name:"Filename"`
	WmInfoSize        requests.Integer              `position:"Body" name:"WmInfoSize"`
	FileUrl           string                        `position:"Body" name:"FileUrl"`
}

// CreateWmExtractTaskCsvControl is a repeated param struct in CreateWmExtractTaskRequest
type CreateWmExtractTaskCsvControl struct {
	Method         string `name:"Method"`
	EmbedColumn    string `name:"EmbedColumn"`
	EmbedPrecision string `name:"EmbedPrecision"`
}

// CreateWmExtractTaskResponse is the response struct for api CreateWmExtractTask
type CreateWmExtractTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateCreateWmExtractTaskRequest creates a request to invoke CreateWmExtractTask API
func CreateCreateWmExtractTaskRequest() (request *CreateWmExtractTaskRequest) {
	request = &CreateWmExtractTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "CreateWmExtractTask", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateWmExtractTaskResponse creates a response to parse from CreateWmExtractTask response
func CreateCreateWmExtractTaskResponse() (response *CreateWmExtractTaskResponse) {
	response = &CreateWmExtractTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
