package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAggregateConfigRule invokes the config.GetAggregateConfigRule API synchronously
func (client *Client) GetAggregateConfigRule(request *GetAggregateConfigRuleRequest) (response *GetAggregateConfigRuleResponse, err error) {
	response = CreateGetAggregateConfigRuleResponse()
	err = client.DoAction(request, response)
	return
}

// GetAggregateConfigRuleWithChan invokes the config.GetAggregateConfigRule API asynchronously
func (client *Client) GetAggregateConfigRuleWithChan(request *GetAggregateConfigRuleRequest) (<-chan *GetAggregateConfigRuleResponse, <-chan error) {
	responseChan := make(chan *GetAggregateConfigRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAggregateConfigRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAggregateConfigRuleWithCallback invokes the config.GetAggregateConfigRule API asynchronously
func (client *Client) GetAggregateConfigRuleWithCallback(request *GetAggregateConfigRuleRequest, callback func(response *GetAggregateConfigRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAggregateConfigRuleResponse
		var err error
		defer close(result)
		response, err = client.GetAggregateConfigRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAggregateConfigRuleRequest is the request struct for api GetAggregateConfigRule
type GetAggregateConfigRuleRequest struct {
	*requests.RpcRequest
	ConfigRuleId string `position:"Query" name:"ConfigRuleId"`
	AggregatorId string `position:"Query" name:"AggregatorId"`
}

// GetAggregateConfigRuleResponse is the response struct for api GetAggregateConfigRule
type GetAggregateConfigRuleResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	ConfigRule ConfigRule `json:"ConfigRule" xml:"ConfigRule"`
}

// CreateGetAggregateConfigRuleRequest creates a request to invoke GetAggregateConfigRule API
func CreateGetAggregateConfigRuleRequest() (request *GetAggregateConfigRuleRequest) {
	request = &GetAggregateConfigRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetAggregateConfigRule", "", "")
	request.Method = requests.POST
	return
}

// CreateGetAggregateConfigRuleResponse creates a response to parse from GetAggregateConfigRule response
func CreateGetAggregateConfigRuleResponse() (response *GetAggregateConfigRuleResponse) {
	response = &GetAggregateConfigRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
