package computenestsupplier

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ReleaseArtifact invokes the computenestsupplier.ReleaseArtifact API synchronously
func (client *Client) ReleaseArtifact(request *ReleaseArtifactRequest) (response *ReleaseArtifactResponse, err error) {
	response = CreateReleaseArtifactResponse()
	err = client.DoAction(request, response)
	return
}

// ReleaseArtifactWithChan invokes the computenestsupplier.ReleaseArtifact API asynchronously
func (client *Client) ReleaseArtifactWithChan(request *ReleaseArtifactRequest) (<-chan *ReleaseArtifactResponse, <-chan error) {
	responseChan := make(chan *ReleaseArtifactResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ReleaseArtifact(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ReleaseArtifactWithCallback invokes the computenestsupplier.ReleaseArtifact API asynchronously
func (client *Client) ReleaseArtifactWithCallback(request *ReleaseArtifactRequest, callback func(response *ReleaseArtifactResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ReleaseArtifactResponse
		var err error
		defer close(result)
		response, err = client.ReleaseArtifact(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ReleaseArtifactRequest is the request struct for api ReleaseArtifact
type ReleaseArtifactRequest struct {
	*requests.RpcRequest
	ArtifactId string `position:"Query" name:"ArtifactId"`
}

// ReleaseArtifactResponse is the response struct for api ReleaseArtifact
type ReleaseArtifactResponse struct {
	*responses.BaseResponse
	RequestId        string `json:"RequestId" xml:"RequestId"`
	ArtifactId       string `json:"ArtifactId" xml:"ArtifactId"`
	ArtifactType     string `json:"ArtifactType" xml:"ArtifactType"`
	VersionName      string `json:"VersionName" xml:"VersionName"`
	ArtifactVersion  string `json:"ArtifactVersion" xml:"ArtifactVersion"`
	Description      string `json:"Description" xml:"Description"`
	GmtModified      string `json:"GmtModified" xml:"GmtModified"`
	Status           string `json:"Status" xml:"Status"`
	ArtifactProperty string `json:"ArtifactProperty" xml:"ArtifactProperty"`
}

// CreateReleaseArtifactRequest creates a request to invoke ReleaseArtifact API
func CreateReleaseArtifactRequest() (request *ReleaseArtifactRequest) {
	request = &ReleaseArtifactRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ComputeNestSupplier", "2021-05-21", "ReleaseArtifact", "", "")
	request.Method = requests.POST
	return
}

// CreateReleaseArtifactResponse creates a response to parse from ReleaseArtifact response
func CreateReleaseArtifactResponse() (response *ReleaseArtifactResponse) {
	response = &ReleaseArtifactResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
