package computenestsupplier

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetServiceTemplateParameterConstraints invokes the computenestsupplier.GetServiceTemplateParameterConstraints API synchronously
func (client *Client) GetServiceTemplateParameterConstraints(request *GetServiceTemplateParameterConstraintsRequest) (response *GetServiceTemplateParameterConstraintsResponse, err error) {
	response = CreateGetServiceTemplateParameterConstraintsResponse()
	err = client.DoAction(request, response)
	return
}

// GetServiceTemplateParameterConstraintsWithChan invokes the computenestsupplier.GetServiceTemplateParameterConstraints API asynchronously
func (client *Client) GetServiceTemplateParameterConstraintsWithChan(request *GetServiceTemplateParameterConstraintsRequest) (<-chan *GetServiceTemplateParameterConstraintsResponse, <-chan error) {
	responseChan := make(chan *GetServiceTemplateParameterConstraintsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetServiceTemplateParameterConstraints(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetServiceTemplateParameterConstraintsWithCallback invokes the computenestsupplier.GetServiceTemplateParameterConstraints API asynchronously
func (client *Client) GetServiceTemplateParameterConstraintsWithCallback(request *GetServiceTemplateParameterConstraintsRequest, callback func(response *GetServiceTemplateParameterConstraintsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetServiceTemplateParameterConstraintsResponse
		var err error
		defer close(result)
		response, err = client.GetServiceTemplateParameterConstraints(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetServiceTemplateParameterConstraintsRequest is the request struct for api GetServiceTemplateParameterConstraints
type GetServiceTemplateParameterConstraintsRequest struct {
	*requests.RpcRequest
	ClientToken                string                                              `position:"Query" name:"ClientToken"`
	EnablePrivateVpcConnection requests.Boolean                                    `position:"Query" name:"EnablePrivateVpcConnection"`
	TemplateName               string                                              `position:"Query" name:"TemplateName"`
	ServiceInstanceId          string                                              `position:"Query" name:"ServiceInstanceId"`
	DeployRegionId             string                                              `position:"Query" name:"DeployRegionId"`
	ServiceVersion             string                                              `position:"Query" name:"ServiceVersion"`
	ServiceId                  string                                              `position:"Query" name:"ServiceId"`
	Parameters                 *[]GetServiceTemplateParameterConstraintsParameters `position:"Query" name:"Parameters"  type:"Repeated"`
}

// GetServiceTemplateParameterConstraintsParameters is a repeated param struct in GetServiceTemplateParameterConstraintsRequest
type GetServiceTemplateParameterConstraintsParameters struct {
	ParameterValue string `name:"ParameterValue"`
	ParameterKey   string `name:"ParameterKey"`
}

// GetServiceTemplateParameterConstraintsResponse is the response struct for api GetServiceTemplateParameterConstraints
type GetServiceTemplateParameterConstraintsResponse struct {
	*responses.BaseResponse
	RequestId            string                     `json:"RequestId" xml:"RequestId"`
	FamilyConstraints    []string                   `json:"FamilyConstraints" xml:"FamilyConstraints"`
	ParameterConstraints []ParameterConstraintsItem `json:"ParameterConstraints" xml:"ParameterConstraints"`
}

// CreateGetServiceTemplateParameterConstraintsRequest creates a request to invoke GetServiceTemplateParameterConstraints API
func CreateGetServiceTemplateParameterConstraintsRequest() (request *GetServiceTemplateParameterConstraintsRequest) {
	request = &GetServiceTemplateParameterConstraintsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ComputeNestSupplier", "2021-05-21", "GetServiceTemplateParameterConstraints", "", "")
	request.Method = requests.POST
	return
}

// CreateGetServiceTemplateParameterConstraintsResponse creates a response to parse from GetServiceTemplateParameterConstraints response
func CreateGetServiceTemplateParameterConstraintsResponse() (response *GetServiceTemplateParameterConstraintsResponse) {
	response = &GetServiceTemplateParameterConstraintsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
